<?php
/**
 * Authors view for BW AI Schema Pro
 *
 * @package BW_AI_Schema_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get all users who can publish posts
$authors = get_users( array(
	'capability' => 'publish_posts',
	'orderby' => 'display_name',
	'order' => 'ASC'
) );
?>

<div class="wrap bw-schema-admin-wrap">
	<h1>
		<span class="dashicons dashicons-admin-users"></span>
		<?php _e( 'Author Schema Profiles', 'bw-ai-schema-pro' ); ?>
	</h1>
	
	<p><?php _e( 'Manage enhanced author profiles for AI-optimized authorship. These profiles help establish credibility and expertise.', 'bw-ai-schema-pro' ); ?></p>
	
	<table class="wp-list-table widefat fixed striped">
		<thead>
			<tr>
				<th><?php _e( 'Author', 'bw-ai-schema-pro' ); ?></th>
				<th><?php _e( 'Posts', 'bw-ai-schema-pro' ); ?></th>
				<th><?php _e( 'Schema Status', 'bw-ai-schema-pro' ); ?></th>
				<th><?php _e( 'Actions', 'bw-ai-schema-pro' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ( $authors as $author ) : 
				$author_data = BW_Schema_Core::get_author_schema( $author->ID );
				$post_count = count_user_posts( $author->ID );
				$has_enhanced_profile = ! empty( $author_data['knowsAbout'] ) || ! empty( $author_data['sameAs'] );
			?>
			<tr>
				<td>
					<strong><?php echo get_avatar( $author->ID, 32 ); ?> <?php echo esc_html( $author->display_name ); ?></strong><br>
					<span class="description"><?php echo esc_html( $author->user_email ); ?></span>
				</td>
				<td><?php echo $post_count; ?></td>
				<td>
					<?php if ( $has_enhanced_profile ) : ?>
						<span style="color: #00a32a;">✓ <?php _e( 'Enhanced', 'bw-ai-schema-pro' ); ?></span>
					<?php else : ?>
						<span style="color: #d63638;">✗ <?php _e( 'Basic', 'bw-ai-schema-pro' ); ?></span>
					<?php endif; ?>
				</td>
				<td>
					<a href="<?php echo admin_url( 'user-edit.php?user_id=' . $author->ID . '#bw-schema-author' ); ?>" class="button button-small">
						<?php _e( 'Edit Profile', 'bw-ai-schema-pro' ); ?>
					</a>
				</td>
			</tr>
			<?php endforeach; ?>
		</tbody>
	</table>
	
	<div class="bw-schema-author-tips" style="margin-top: 40px; background: #fff; padding: 20px; border: 1px solid #ddd; border-radius: 8px;">
		<h2><?php _e( 'Enhancing Author Profiles for AI', 'bw-ai-schema-pro' ); ?></h2>
		<p><?php _e( 'To maximize author credibility in the AI era, ensure each author profile includes:', 'bw-ai-schema-pro' ); ?></p>
		
		<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px; margin-top: 20px;">
			<div>
				<h3><?php _e( 'Essential Information', 'bw-ai-schema-pro' ); ?></h3>
				<ul>
					<li><?php _e( 'Professional bio/description', 'bw-ai-schema-pro' ); ?></li>
					<li><?php _e( 'Areas of expertise (knowsAbout)', 'bw-ai-schema-pro' ); ?></li>
					<li><?php _e( 'Professional credentials', 'bw-ai-schema-pro' ); ?></li>
					<li><?php _e( 'Education background', 'bw-ai-schema-pro' ); ?></li>
				</ul>
			</div>
			
			<div>
				<h3><?php _e( 'Trust Signals', 'bw-ai-schema-pro' ); ?></h3>
				<ul>
					<li><?php _e( 'Social media profiles (sameAs)', 'bw-ai-schema-pro' ); ?></li>
					<li><?php _e( 'Professional memberships', 'bw-ai-schema-pro' ); ?></li>
					<li><?php _e( 'Awards and recognition', 'bw-ai-schema-pro' ); ?></li>
					<li><?php _e( 'Published works', 'bw-ai-schema-pro' ); ?></li>
				</ul>
			</div>
		</div>
	</div>
</div>