<?php
/**
 * Author Profiles Admin Page
 *
 * @package BW_AI_Schema_Pro
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Get all custom authors
$authors = get_option('bw_schema_custom_authors', array());
$use_custom_authors = get_option('bw_schema_use_custom_authors', 'no');

// Handle search
$search_query = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';
if ($search_query) {
    $authors = array_filter($authors, function($author) use ($search_query) {
        return stripos($author['name'], $search_query) !== false || 
               stripos($author['jobTitle'] ?? '', $search_query) !== false ||
               stripos($author['description'] ?? '', $search_query) !== false;
    });
}

// Get author to edit
$edit_author = null;
$edit_author_id = null;
if (isset($_GET['action']) && $_GET['action'] === 'edit' && isset($_GET['author_id'])) {
    $edit_author_id = sanitize_text_field($_GET['author_id']);
    foreach ($authors as $author) {
        if ($author['id'] == $edit_author_id) {
            $edit_author = $author;
            break;
        }
    }
}
?>

<div class="wrap bw-schema-admin-wrap">
    <h1><?php _e( 'BW AI Schema Pro', 'bw-ai-schema-pro' ); ?></h1>

    <!-- Tab Navigation -->
    <nav class="nav-tab-wrapper bw-schema-nav-tabs">
        <a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema' ); ?>" class="nav-tab">
            <span class="dashicons dashicons-dashboard"></span>
            <?php _e( 'Dashboard', 'bw-ai-schema-pro' ); ?>
        </a>
        <a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-settings' ); ?>" class="nav-tab">
            <span class="dashicons dashicons-admin-generic"></span>
            <?php _e( 'Settings', 'bw-ai-schema-pro' ); ?>
        </a>
        <a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-authors' ); ?>" class="nav-tab nav-tab-active">
            <span class="dashicons dashicons-admin-users"></span>
            <?php _e( 'Author Profiles', 'bw-ai-schema-pro' ); ?>
        </a>
        <a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup' ); ?>" class="nav-tab">
            <span class="dashicons dashicons-welcome-learn-more"></span>
            <?php _e( 'Setup Wizard', 'bw-ai-schema-pro' ); ?>
        </a>
    </nav>

    <div style="margin-top: 20px;">
        <a href="#add-new-author" class="page-title-action"><?php _e( 'Add New Author', 'bw-ai-schema-pro' ); ?></a>
    </div>

    <!-- Author Settings -->
    <div class="bw-ai-schema-settings-box" style="margin: 20px 0; padding: 15px; background: #fff; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
        <h3>Author Settings</h3>
        <form method="post" action="">
            <?php wp_nonce_field('bw_schema_author', 'bw_schema_author_nonce'); ?>
            <input type="hidden" name="bw_schema_save_author" value="1">
            <label>
                <input type="radio" name="use_custom_authors" value="yes" <?php checked($use_custom_authors, 'yes'); ?>>
                Use custom authors instead of WordPress users in post meta box
            </label><br>
            <label>
                <input type="radio" name="use_custom_authors" value="no" <?php checked($use_custom_authors, 'no'); ?>>
                Use WordPress users (default)
            </label>
            <p class="description">When custom authors is enabled, the post meta box will show custom authors instead of WordPress users.</p>
            <p class="submit">
                <input type="submit" class="button button-primary" value="Save Settings">
            </p>
        </form>
    </div>
    
    <!-- Search Box -->
    <form method="get" action="">
        <input type="hidden" name="page" value="bw-ai-schema-authors">
        <p class="search-box">
            <label class="screen-reader-text" for="author-search-input">Search Authors:</label>
            <input type="search" id="author-search-input" name="s" value="<?php echo esc_attr($search_query); ?>">
            <input type="submit" id="search-submit" class="button" value="Search Authors">
        </p>
    </form>
    
    <!-- Authors Table -->
    <form method="post" action="">
        <?php wp_nonce_field('bulk-authors'); ?>
        <input type="hidden" name="action" value="bulk-delete">
        
        <div class="tablenav top">
            <div class="alignleft actions bulkactions">
                <select name="bulk_action" id="bulk-action-selector-top">
                    <option value="">Bulk Actions</option>
                    <option value="delete">Delete</option>
                </select>
                <input type="submit" id="doaction" class="button action" value="Apply" onclick="return confirm('Are you sure you want to delete selected authors?');">
            </div>
        </div>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <td class="manage-column column-cb check-column">
                        <input type="checkbox" id="cb-select-all-1">
                    </td>
                    <th class="manage-column">Image</th>
                    <th class="manage-column">Name</th>
                    <th class="manage-column">Job Title</th>
                    <th class="manage-column">Description</th>
                    <th class="manage-column">Default</th>
                    <th class="manage-column">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($authors)): ?>
                    <tr>
                        <td colspan="7" style="text-align: center;">No authors found.</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($authors as $author): ?>
                        <tr>
                            <th scope="row" class="check-column">
                                <input type="checkbox" name="author_ids[]" value="<?php echo esc_attr($author['id']); ?>">
                            </th>
                            <td>
                                <?php if (!empty($author['image'])): ?>
                                    <img src="<?php echo esc_url($author['image']); ?>" alt="<?php echo esc_attr($author['name']); ?>" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%;">
                                <?php else: ?>
                                    <div style="width: 50px; height: 50px; background: #ddd; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                        <span style="font-size: 20px; color: #666;"><?php echo esc_html(substr($author['name'], 0, 1)); ?></span>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <strong><?php echo esc_html($author['name']); ?></strong>
                                <?php if (!empty($author['credentials'])): ?>
                                    <br><small><?php echo esc_html($author['credentials']); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo esc_html($author['jobTitle'] ?? ''); ?>
                                <?php 
                                $link_url = '';
                                if (!empty($author['teamPageUrl'])) {
                                    // External URL
                                    $link_url = $author['teamPageUrl'];
                                } elseif (!empty($author['teamPageId']) && $author['teamPageId'] !== 'custom') {
                                    // Internal page/post
                                    $link_url = get_permalink($author['teamPageId']);
                                }
                                ?>
                                <?php if ($link_url): ?>
                                    <br><small><a href="<?php echo esc_url($link_url); ?>" target="_blank">View Page ↗</a></small>
                                <?php endif; ?>
                            </td>
                            <td><?php echo wp_trim_words(wp_strip_all_tags($author['description'] ?? ''), 20); ?></td>
                            <td>
                                <?php if (!empty($author['isDefault'])): ?>
                                    <span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="?page=bw-ai-schema-authors&action=edit&author_id=<?php echo esc_attr($author['id']); ?>#add-new-author" class="button button-small">Edit</a>
                                <?php
                                $delete_url = wp_nonce_url(
                                    "?page=bw-ai-schema-authors&action=delete&author=" . $author['id'],
                                    'delete_author'
                                );
                                ?>
                                <a href="<?php echo esc_url($delete_url); ?>" class="button button-small" onclick="return confirm('Are you sure you want to delete this author?');">Delete</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </form>
    
    <!-- Add/Edit Author Form -->
    <div id="add-new-author" style="margin-top: 30px; padding: 20px; background: #fff; border: 1px solid #ccd0d4; box-shadow: 0 1px 1px rgba(0,0,0,.04);">
        <h2><?php echo $edit_author ? 'Edit Author' : 'Add New Author'; ?></h2>
        
        <!-- Profile Completeness Guide -->
        <div style="background: #f0f6fc; border-left: 4px solid #2271b1; padding: 15px; margin-bottom: 20px;">
            <h3 style="margin-top: 0; color: #2271b1;">📝 Industry Standard Author Schema</h3>
            <p style="margin-bottom: 10px;">Complete profiles help search engines and AI systems better understand author credibility and expertise. Fill in as many fields as possible for optimal results.</p>
            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; font-size: 14px;">
                <div>✅ <strong>Essential:</strong> Name, Job Title, Description, Image</div>
                <div>🎯 <strong>Highly Recommended:</strong> Email, Areas of Expertise</div>
                <div>💪 <strong>Credibility Boosters:</strong> Credentials, Affiliations</div>
                <div>🔗 <strong>Connections:</strong> Social Profiles, Alumni Of</div>
            </div>
        </div>
        
        <form method="post" action="">
            <?php wp_nonce_field('bw_schema_author', 'bw_schema_author_nonce'); ?>
            <input type="hidden" name="bw_schema_save_author" value="1">
            <?php if ($edit_author): ?>
                <input type="hidden" name="author_id" value="<?php echo esc_attr($edit_author_id); ?>">
            <?php endif; ?>
            
            <!-- Profile Strength Indicator -->
            <div id="profile-strength" style="margin-bottom: 20px; padding: 15px; background: #fff; border: 1px solid #e0e0e0; border-radius: 5px;">
                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <strong>Profile Strength: </strong>
                        <span id="strength-text">Basic</span>
                    </div>
                    <div style="width: 200px;">
                        <div style="background: #e0e0e0; height: 8px; border-radius: 4px; position: relative;">
                            <div id="strength-bar" style="background: #dc3545; height: 100%; width: 0%; border-radius: 4px; transition: all 0.3s ease;"></div>
                        </div>
                    </div>
                </div>
                <div id="strength-tips" style="margin-top: 10px; font-size: 13px; color: #666;"></div>
            </div>
            
            <table class="form-table">
                <!-- Essential Fields (Always Visible) -->
                <tr class="essential-field">
                    <th scope="row"><label for="author_name">Name <span class="required">*</span></label></th>
                    <td>
                        <input type="text" id="author_name" name="author_name" class="regular-text" required value="<?php echo $edit_author ? esc_attr($edit_author['name']) : ''; ?>" data-strength="essential">
                    </td>
                </tr>
                <tr class="essential-field">
                    <th scope="row"><label for="author_job_title">Job Title <span style="color: #f0ad4e;">★</span></label></th>
                    <td>
                        <input type="text" id="author_job_title" name="author_job_title" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['jobTitle'] ?? '') : ''; ?>" placeholder="e.g., CEO, Content Manager, Guest Contributor" data-strength="essential">
                        <p class="description">Essential for establishing authority</p>
                    </td>
                </tr>
                <tr class="essential-field">
                    <th scope="row"><label for="author_description">Description <span style="color: #f0ad4e;">★</span></label></th>
                    <td>
                        <textarea id="author_description" name="author_description" rows="5" class="large-text" placeholder="Brief bio highlighting expertise and experience..." data-strength="essential"><?php echo $edit_author ? esc_textarea($edit_author['description'] ?? '') : ''; ?></textarea>
                        <p class="description">A compelling bio significantly improves schema effectiveness</p>
                    </td>
                </tr>
                <tr class="essential-field">
                    <th scope="row"><label for="author_image">Profile Image <span style="color: #f0ad4e;">★</span></label></th>
                    <td>
                        <input type="url" id="author_image" name="author_image" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['image'] ?? '') : ''; ?>" placeholder="https://example.com/image.jpg" data-strength="essential">
                        <button type="button" class="button" id="upload_image_button">Upload Image</button>
                        <p class="description">Professional headshot builds trust</p>
                        <div id="image_preview" style="margin-top: 10px;">
                            <?php if ($edit_author && !empty($edit_author['image'])): ?>
                                <img src="<?php echo esc_url($edit_author['image']); ?>" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px;">
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="author_team_page">Team/Author Page Link</label></th>
                    <td>
                        <div style="margin-bottom: 10px;">
                            <input type="radio" id="link_type_internal" name="author_link_type" value="internal" <?php echo (!$edit_author || empty($edit_author['teamPageUrl']) || (!empty($edit_author['teamPageId']) && $edit_author['teamPageId'] !== 'custom')) ? 'checked' : ''; ?>>
                            <label for="link_type_internal">Select from existing content</label>
                            &nbsp;&nbsp;
                            <input type="radio" id="link_type_external" name="author_link_type" value="external" <?php echo ($edit_author && (!empty($edit_author['teamPageUrl']) || $edit_author['teamPageId'] === 'custom')) ? 'checked' : ''; ?>>
                            <label for="link_type_external">Enter custom URL</label>
                        </div>
                        
                        <div id="internal_link_section" style="<?php echo (!$edit_author || empty($edit_author['teamPageUrl']) || (!empty($edit_author['teamPageId']) && $edit_author['teamPageId'] !== 'custom')) ? '' : 'display:none;'; ?>">
                            <select id="author_team_page" name="author_team_page" class="regular-text" data-strength="recommended">
                                <option value="">-- Select Page/Post --</option>
                                <?php
                                $selected_page = $edit_author ? ($edit_author['teamPageId'] ?? '') : '';
                                BW_Schema_Helpers::render_post_select_options($selected_page, true);
                                ?>
                            </select>
                        </div>
                        
                        <div id="external_link_section" style="<?php echo ($edit_author && (!empty($edit_author['teamPageUrl']) || $edit_author['teamPageId'] === 'custom')) ? '' : 'display:none;'; ?>">
                            <input type="url" id="author_team_url" name="author_team_url" class="regular-text" 
                                value="<?php echo $edit_author ? esc_url($edit_author['teamPageUrl'] ?? '') : ''; ?>" 
                                placeholder="https://example.com/author/john-doe">
                        </div>
                        
                        <p class="description">Link to author's page (internal or external) for better SEO and credibility</p>
                    </td>
                </tr>
                
                <!-- Complete Profile Button -->
                <tr id="complete-profile-row">
                    <th scope="row"></th>
                    <td>
                        <button type="button" id="toggle-advanced-fields" class="button button-secondary">
                            <span class="dashicons dashicons-arrow-down-alt2"></span>
                            Complete Profile for Better Results
                        </button>
                        <span style="margin-left: 10px; color: #666;">Add credentials, expertise, and social profiles</span>
                    </td>
                </tr>
                
                <!-- Advanced Fields (Initially Hidden) -->
                <tbody id="advanced-fields" style="display: none;">
                    <tr>
                        <th scope="row"><label for="author_email">Email</label></th>
                        <td>
                            <input type="email" id="author_email" name="author_email" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['email'] ?? '') : ''; ?>" placeholder="author@example.com" data-strength="recommended">
                            <p class="description">Adds contactability and legitimacy</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="author_credentials">Credentials</label></th>
                        <td>
                            <input type="text" id="author_credentials" name="author_credentials" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['credentials'] ?? '') : ''; ?>" placeholder="e.g., Ph.D., M.D., CPA, MBA" data-strength="credibility">
                            <p class="description">Professional certifications boost authority</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="author_expertise">Areas of Expertise</label></th>
                        <td>
                            <input type="text" id="author_expertise" name="author_expertise" class="large-text" value="<?php echo $edit_author ? esc_attr($edit_author['expertise'] ?? '') : ''; ?>" placeholder="Digital Marketing, SEO, Content Strategy, Business Development" data-strength="recommended">
                            <p class="description">Helps AI understand author's knowledge domains (comma-separated)</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="author_affiliations">Professional Affiliations</label></th>
                        <td>
                            <input type="text" id="author_affiliations" name="author_affiliations" class="large-text" value="<?php echo $edit_author ? esc_attr($edit_author['affiliations'] ?? '') : ''; ?>" placeholder="American Marketing Association, Chamber of Commerce" data-strength="credibility">
                            <p class="description">Memberships and associations (comma-separated)</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="author_alumni">Education</label></th>
                        <td>
                            <input type="text" id="author_alumni" name="author_alumni" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['alumniOf'] ?? '') : ''; ?>" placeholder="Harvard University, Stanford GSB" data-strength="credibility">
                            <p class="description">Educational background</p>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">Social Profiles</th>
                        <td>
                            <div style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 15px;">
                                <div>
                                    <label for="author_linkedin">LinkedIn:</label>
                                    <input type="url" id="author_linkedin" name="author_linkedin" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['social']['linkedin'] ?? '') : ''; ?>" placeholder="https://linkedin.com/in/yourprofile" data-strength="social">
                                </div>
                                <div>
                                    <label for="author_twitter">Twitter/X:</label>
                                    <input type="url" id="author_twitter" name="author_twitter" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['social']['twitter'] ?? '') : ''; ?>" placeholder="https://x.com/yourprofile" data-strength="social">
                                </div>
                                <div>
                                    <label for="author_facebook">Facebook:</label>
                                    <input type="url" id="author_facebook" name="author_facebook" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['social']['facebook'] ?? '') : ''; ?>" placeholder="https://facebook.com/yourpage" data-strength="social">
                                </div>
                                <div>
                                    <label for="author_website">Website:</label>
                                    <input type="url" id="author_website" name="author_website" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['social']['website'] ?? '') : ''; ?>" placeholder="https://yourwebsite.com" data-strength="social">
                                </div>
                                <div>
                                    <label for="author_instagram">Instagram:</label>
                                    <input type="url" id="author_instagram" name="author_instagram" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['social']['instagram'] ?? '') : ''; ?>" placeholder="https://instagram.com/yourprofile" data-strength="social">
                                </div>
                                <div>
                                    <label for="author_youtube">YouTube:</label>
                                    <input type="url" id="author_youtube" name="author_youtube" class="regular-text" value="<?php echo $edit_author ? esc_attr($edit_author['social']['youtube'] ?? '') : ''; ?>" placeholder="https://youtube.com/@yourchannel" data-strength="social">
                                </div>
                            </div>
                            <p class="description" style="margin-top: 10px;">Social profiles significantly enhance author credibility</p>
                        </td>
                    </tr>
                </tbody>
                <tr>
                    <th scope="row"><label for="author_default">Default Author</label></th>
                    <td>
                        <label>
                            <input type="checkbox" id="author_default" name="author_default" value="1" <?php echo ($edit_author && !empty($edit_author['isDefault'])) ? 'checked' : ''; ?>>
                            Set as default author for schema markup
                        </label>
                        <p class="description">This author will be used by default when no specific author is selected.</p>
                    </td>
                </tr>
            </table>
            
            <p class="submit">
                <input type="submit" class="button button-primary" value="<?php echo $edit_author ? 'Update Author' : 'Add Author'; ?>">
                <?php if ($edit_author): ?>
                    <a href="?page=bw-ai-schema-authors" class="button">Cancel</a>
                <?php endif; ?>
            </p>
        </form>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Toggle advanced fields
    $('#toggle-advanced-fields').click(function() {
        var $advancedFields = $('#advanced-fields');
        var $button = $(this);
        var $icon = $button.find('.dashicons');
        
        if ($advancedFields.is(':visible')) {
            $advancedFields.slideUp();
            $icon.removeClass('dashicons-arrow-up-alt2').addClass('dashicons-arrow-down-alt2');
            $button.html('<span class="dashicons dashicons-arrow-down-alt2"></span> Complete Profile for Better Results');
        } else {
            $advancedFields.slideDown();
            $icon.removeClass('dashicons-arrow-down-alt2').addClass('dashicons-arrow-up-alt2');
            $button.html('<span class="dashicons dashicons-arrow-up-alt2"></span> Hide Advanced Fields');
        }
    });
    
    // Auto-expand if editing and has advanced fields filled
    <?php if ($edit_author && (!empty($edit_author['email']) || !empty($edit_author['expertise']) || !empty($edit_author['affiliations']))): ?>
        $('#toggle-advanced-fields').click();
    <?php endif; ?>
    
    // Profile Strength Calculator
    function calculateProfileStrength() {
        var strength = 0;
        var tips = [];
        
        // Essential fields (40% total)
        if ($('#author_name').val()) strength += 10;
        if ($('#author_job_title').val()) strength += 10;
        if ($('#author_description').val()) strength += 10;
        if ($('#author_image').val()) strength += 10;
        
        // Recommended fields (30% total)
        if ($('#author_email').val()) strength += 15;
        if ($('#author_expertise').val()) strength += 15;
        
        // Credibility fields (20% total)
        if ($('#author_credentials').val()) strength += 6;
        if ($('#author_affiliations').val()) strength += 7;
        if ($('#author_alumni').val()) strength += 7;
        
        // Social profiles (10% total - 2% each)
        var socialFields = ['#author_linkedin', '#author_twitter', '#author_facebook', '#author_website', '#author_youtube'];
        socialFields.forEach(function(field) {
            if ($(field).val()) strength += 2;
        });
        
        // Update progress bar
        var $bar = $('#strength-bar');
        var $text = $('#strength-text');
        var $tips = $('#strength-tips');
        
        $bar.css('width', strength + '%');
        
        // Update color and text based on strength
        if (strength >= 80) {
            $bar.css('background', '#46b450');
            $text.text('Excellent');
            $tips.html('✨ Your profile is fully optimized for search engines and AI!');
        } else if (strength >= 60) {
            $bar.css('background', '#f0ad4e');
            $text.text('Good');
            
            // Provide specific tips
            if (!$('#author_email').val()) tips.push('Add email for better contactability');
            if (!$('#author_expertise').val()) tips.push('Add areas of expertise');
            if (!$('#author_linkedin').val()) tips.push('Add LinkedIn profile');
            
            $tips.html('💡 Tips: ' + tips.join(' • '));
        } else if (strength >= 40) {
            $bar.css('background', '#dc3545');
            $text.text('Basic');
            
            // Check essential fields
            if (!$('#author_job_title').val()) tips.push('Add job title');
            if (!$('#author_description').val()) tips.push('Add description');
            if (!$('#author_image').val()) tips.push('Add profile image');
            
            $tips.html('⚠️ Complete essential fields: ' + tips.join(' • '));
        } else {
            $bar.css('background', '#dc3545');
            $text.text('Incomplete');
            $tips.html('🚨 Please fill in at least the essential fields marked with ★');
        }
    }
    
    // Calculate on page load
    calculateProfileStrength();
    
    // Recalculate on field changes
    $('input[data-strength], textarea[data-strength]').on('change keyup', function() {
        calculateProfileStrength();
    });
    
    // Ensure media uploader is available
    if (typeof wp !== 'undefined' && typeof wp.media !== 'undefined') {
        // Media uploader
        $('#upload_image_button').click(function(e) {
            e.preventDefault();
            
            var mediaUploader = wp.media({
                title: 'Select Author Image',
                button: {
                    text: 'Use this image'
                },
                multiple: false
            });
            
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $('#author_image').val(attachment.url);
                
                // Update preview
                if (attachment.url) {
                    var img = '<img src="' + attachment.url + '" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px;">';
                    $('#image_preview').html(img);
                }
                
                // Recalculate strength
                calculateProfileStrength();
            });
            
            mediaUploader.open();
        });
    } else {
        // Hide upload button if media uploader is not available
        $('#upload_image_button').hide();
    }
    
    // Update preview when URL is manually entered
    $('#author_image').on('change blur', function() {
        var url = $(this).val();
        if (url) {
            var img = '<img src="' + url + '" style="max-width: 150px; height: auto; border: 1px solid #ddd; padding: 5px;" onerror="this.style.display=\'none\'">';
            $('#image_preview').html(img);
        } else {
            $('#image_preview').html('');
        }
    });
    
    // Handle link type radio buttons
    $('input[name="author_link_type"]').change(function() {
        if ($(this).val() === 'internal') {
            $('#internal_link_section').show();
            $('#external_link_section').hide();
            $('#author_team_url').val(''); // Clear external URL
        } else {
            $('#internal_link_section').hide();
            $('#external_link_section').show();
            $('#author_team_page').val(''); // Clear internal selection
        }
        calculateProfileStrength(); // Recalculate strength
    });
    
    // Select all checkboxes
    $('#cb-select-all-1').change(function() {
        $('tbody input[type="checkbox"]').prop('checked', $(this).prop('checked'));
    });
});
</script>

<style>
.bw-ai-schema-settings-box h3 {
    margin-top: 0;
    margin-bottom: 15px;
}

.required {
    color: #dc3232;
}

.form-table th {
    width: 200px;
}

.wp-list-table .column-cb {
    width: 2.2em;
}

.wp-list-table img {
    vertical-align: middle;
}

/* Profile strength indicator */
#profile-strength {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

/* Advanced fields transition */
#advanced-fields {
    transition: all 0.3s ease;
}

/* Essential field indicators */
.essential-field label span[style*="f0ad4e"] {
    font-size: 16px;
    vertical-align: middle;
}

/* Complete profile button */
#toggle-advanced-fields {
    transition: all 0.2s ease;
}

#toggle-advanced-fields:hover {
    background: #0073aa;
    color: #fff;
    border-color: #0073aa;
}

/* Social profile grid */
#advanced-fields input[type="url"] {
    width: 100%;
}

/* Hover effects for better UX */
.form-table input:focus,
.form-table textarea:focus {
    border-color: #0073aa;
    box-shadow: 0 0 0 1px #0073aa;
}

/* Profile completeness visual feedback */
#strength-bar {
    position: relative;
    overflow: hidden;
}

#strength-bar::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    bottom: 0;
    right: 0;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
    animation: shimmer 2s infinite;
}

@keyframes shimmer {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}
</style>