# Team Schema Guide for BW AI Schema Pro

## Overview

The BW AI Schema Pro plugin generates structured data for team pages to help search engines and AI systems understand your team structure. This guide explains how to set up and troubleshoot team schema functionality.

## How Team Pages Are Detected

The plugin uses multiple methods to identify team pages:

### 1. **URL Pattern Detection**
The plugin automatically detects pages with these URL patterns:
- `/team`
- `/our-team`
- `/meet-the-team`
- `/staff`
- `/about/team`
- `/about-us/team`
- `/company/team`

### 2. **Page Slug Detection**
Pages with these slugs are automatically recognized:
- `team`
- `our-team`
- `meet-the-team`
- `staff`
- `employees`
- `team-members`

### 3. **Manual Page Designation**
For pages that don't match the patterns above:
1. Edit the page in WordPress
2. Look for "Team Page Settings" in the sidebar
3. Check "This is a team page"
4. Update/Save the page

### 4. **Content Detection**
The plugin detects pages containing:
- Query Loop blocks displaying team member post type
- Team-related shortcodes
- Custom team member displays

## Setup Instructions

### Step 1: Configure Team Post Type
1. Go to **AI Schema Pro → Global Settings**
2. Find "Team Member Post Type" dropdown
3. Select your team member post type (e.g., `team`, `staff`, `sw_teammember`)
4. Save settings

### Step 2: Create Team Members
1. Create posts in your selected team member post type
2. Fill in team member details:
   - Name (post title)
   - Bio/Description (post content)
   - Featured image (team member photo)
   - Job title (if using custom fields)

### Step 3: Create Team Page
1. Create a new page or edit existing team page
2. Add your team members using:
   - Query Loop block (recommended)
   - Team shortcode
   - Custom page builder elements
3. If page URL doesn't contain `/team`, check "This is a team page" in sidebar

### Step 4: Verify Schema Output
1. Visit your team page
2. View page source
3. Look for `<!-- BW AI Schema Pro -->` comments
4. Check for `ItemList` schema containing `Person` schemas

## Troubleshooting

### Team Schema Not Appearing

1. **Check if debugging is enabled:**
   - Add `?debug_team_schema=1` to your WordPress admin URL
   - Or copy `mu-plugins/bw-schema-debug.php` to `wp-content/mu-plugins/`

2. **View debug info in page source:**
   Look for `<!-- BW AI Schema Pro Debug Info -->` comments showing:
   - Current URL
   - Team post type setting
   - Whether page is detected as team page

3. **Common issues:**
   - Wrong team post type selected in settings
   - No published team members
   - Page not detected as team page (use manual designation)
   - Schema output disabled globally

### Testing Your Schema

1. **Google Rich Results Test:**
   - Visit: https://search.google.com/test/rich-results
   - Enter your team page URL
   - Check for detected structured data

2. **Schema Markup Validator:**
   - Visit: https://validator.schema.org/
   - Paste your schema JSON-LD
   - Verify no errors

## Schema Output Example

A properly configured team page will output schema like:

```json
{
  "@context": "https://schema.org",
  "@type": "ItemList",
  "name": "Our Team",
  "url": "https://yoursite.com/team",
  "numberOfItems": 3,
  "itemListElement": [
    {
      "@type": "ListItem",
      "position": 1,
      "item": {
        "@type": "Person",
        "name": "John Doe",
        "jobTitle": "CEO",
        "description": "John leads our company with over 20 years experience...",
        "image": "https://yoursite.com/john-doe.jpg",
        "url": "https://yoursite.com/team/john-doe"
      }
    }
  ]
}
```

## Advanced Configuration

### Custom URL Patterns
Add custom patterns via filter:
```php
add_filter( 'bw_schema_team_url_patterns', function( $patterns ) {
    $patterns[] = '/notre-equipe'; // French
    $patterns[] = '/unser-team';   // German
    return $patterns;
} );
```

### Custom Team Shortcodes
Register your shortcodes for detection:
```php
add_filter( 'bw_schema_team_shortcodes', function( $shortcodes ) {
    $shortcodes[] = 'my_custom_team_grid';
    return $shortcodes;
} );
```

## Support

If team schema still isn't working:

1. Enable WP_DEBUG and check for errors
2. Verify plugin is activated and up to date
3. Check for conflicts with other SEO/schema plugins
4. Use the debug tool to gather information
5. Contact support with debug output

---
Last updated: Version 1.0.0