# BW AI Schema Pro - Testing Guide

**Last Updated:** 2026-01-15

Manual verification checklists and testing procedures.

---

## Quick Smoke Test

Run this after any changes to verify basic functionality:

- [ ] Site loads without PHP errors
- [ ] Admin > Settings > AI Schema Pro loads
- [ ] View source on homepage shows `<!-- BW AI Schema Pro -->` comment
- [ ] View source on a post shows Article schema
- [ ] Post editor shows Schema Settings meta box

---

## Pre-Release Checklist

Complete all sections before any release.

### 1. Schema Output Verification

**Homepage:**
- [ ] View source contains `<script type="application/ld+json">`
- [ ] WebSite schema present with name, url
- [ ] SearchAction present (if enabled)
- [ ] No duplicate schemas from other plugins

**Blog Post:**
- [ ] Article or BlogPosting schema present
- [ ] Schema contains: headline, datePublished, dateModified
- [ ] Schema contains: author with name
- [ ] Schema contains: publisher with Organization
- [ ] BreadcrumbList schema present
- [ ] Word count included in schema

**Page:**
- [ ] WebPage schema present
- [ ] BreadcrumbList schema present

**Team Page:**
- [ ] ItemList schema present
- [ ] Contains Person items for team members
- [ ] Each Person has: name, jobTitle, description

**Validation:**
- [ ] Passes Google Rich Results Test: https://search.google.com/test/rich-results
- [ ] Passes Schema.org Validator: https://validator.schema.org/

---

### 2. Author System Verification

**Single WordPress Author:**
- [ ] Author byline shows correct WP user name
- [ ] Schema contains author with Person type
- [ ] Author box displays (if enabled)

**Single Custom Author:**
- [ ] Author byline shows custom author name (NOT WP user)
- [ ] Schema contains custom author data
- [ ] Author box shows custom author with image, bio

**Multiple Authors:**
- [ ] Byline shows formatted names ("A and B" or "A, B and C")
- [ ] Schema contains array of Person objects
- [ ] Author box shows all authors

**External Author:**
- [ ] External author data saves correctly
- [ ] Schema contains external author data
- [ ] Author box shows external author

---

### 3. Admin Interface Verification

**Dashboard:**
- [ ] Setup completion percentage displays
- [ ] Missing items listed with links
- [ ] Navigation to other tabs works

**Settings:**
- [ ] All settings save correctly
- [ ] Organization data persists
- [ ] Feature toggles work
- [ ] Conflict management options save

**Author Profiles:**
- [ ] Can create new custom author
- [ ] Can edit existing author
- [ ] Can delete author
- [ ] Profile strength indicator updates
- [ ] Default author selection works

**Post Meta Box:**
- [ ] Appears on configured post types
- [ ] Schema type dropdown works
- [ ] Simple mode shows type-specific fields
- [ ] Advanced mode shows JSON editor
- [ ] Multiple authors can be added
- [ ] Schema preview loads via AJAX
- [ ] Settings save with post

**Setup Wizard:**
- [ ] All 7 steps accessible
- [ ] Progress saves between steps
- [ ] Back navigation works
- [ ] Skip option works
- [ ] Completion redirects to dashboard

---

### 4. Theme Compatibility Matrix

Test author display with these themes:

| Theme | Byline Shows Custom Author | Author Box Works | Notes |
|-------|---------------------------|------------------|-------|
| Kadence | [ ] | [ ] | **Known issue - see ISSUE-001** |
| Twenty Twenty-Four | [ ] | [ ] | |
| Astra | [ ] | [ ] | |
| GeneratePress | [ ] | [ ] | |
| OceanWP | [ ] | [ ] | |
| Genesis | [ ] | [ ] | |

---

### 5. Conflict Management

Test with these plugins installed:

| Plugin | Schema Disabled | No Errors | No Duplicates |
|--------|-----------------|-----------|---------------|
| Yoast SEO | [ ] | [ ] | [ ] |
| Rank Math | [ ] | [ ] | [ ] |
| All in One SEO | [ ] | [ ] | [ ] |
| SEOPress | [ ] | [ ] | [ ] |
| WooCommerce | [ ] | [ ] | [ ] |

---

### 6. Edge Cases

- [ ] Post with no featured image - schema still valid
- [ ] Post with no excerpt - uses content
- [ ] Post with no categories - schema handles gracefully
- [ ] Custom author with no image - placeholder or fallback
- [ ] Very long post (10,000+ words) - no timeout
- [ ] Post with 10+ authors - displays "and X others"

---

## Test URLs

**Validation Tools:**
- Google Rich Results Test: https://search.google.com/test/rich-results
- Schema.org Validator: https://validator.schema.org/
- Schema Markup Validator: https://www.schemavalidator.org/

**Test Site:**
- Homepage: https://rise.demoing.info/
- Blog Post: https://rise.demoing.info/blog/[post-slug]/
- Team Page: https://rise.demoing.info/team/
- Admin: https://rise.demoing.info/wp-admin/options-general.php?page=bw-ai-schema

---

## Testing Commands

**View schema in page source:**
```bash
curl -s https://rise.demoing.info/ | grep -A 50 "BW AI Schema Pro"
```

**Check for PHP errors:**
```bash
srv-gw logs --project rise | grep -i "error\|warning\|fatal"
```

**Validate JSON-LD:**
```bash
curl -s https://rise.demoing.info/ | \
  grep -oP '(?<=<script type="application/ld\+json">).*?(?=</script>)' | \
  head -1 | python3 -m json.tool
```

---

## Regression Test Procedure

Before making changes that affect core functionality:

1. **Record current state:**
   - Screenshot of admin pages
   - Copy of schema output from test post
   - Note which features work

2. **Make changes**

3. **Run Quick Smoke Test** (above)

4. **Compare:**
   - Schema output matches or improves
   - No new PHP errors
   - Admin pages still functional

5. **Document** any changes in SESSION-LOG.md

---

## Bug Report Template

When finding issues, document with:

```markdown
### Bug Title

**Steps to Reproduce:**
1. Step 1
2. Step 2
3. Step 3

**Expected Result:**
What should happen

**Actual Result:**
What actually happens

**Environment:**
- Plugin version:
- WordPress version:
- Theme:
- Other relevant plugins:

**Screenshots:**
[If applicable]

**Console Errors:**
[If any]
```
