# BW AI Schema Pro - Feature Specification

**Version:** 1.1.0 | **Last Updated:** 2026-01-15

This document defines WHAT the plugin must do. Any refactoring must preserve all features marked as **[REQUIRED]**. Check this document before and after any significant changes.

---

## Status Legend

- **[PASSING]** - Feature works as specified
- **[FAILING]** - Feature is broken (see KNOWN-ISSUES.md)
- **[PARTIAL]** - Some acceptance criteria pass, some fail
- **[UNTESTED]** - Not yet verified

---

## 1. Author Management System [REQUIRED]

### 1.1 Author Types
**Description:** Support three types of authors for posts.

| Type | Storage | Source |
|------|---------|--------|
| WordPress User | `wordpress_user_id` in post meta | `wp_users` table |
| Custom Author | `custom_author_id` in post meta | `bw_schema_custom_authors` option |
| External Author | `external` object in post meta | Inline data per-post |

**Acceptance Criteria:**
- [x] AC-1.1.1: Admin can select WordPress user as author from dropdown
- [x] AC-1.1.2: Admin can select custom author from dropdown
- [x] AC-1.1.3: Admin can create external author with inline fields (name, bio, image, social)
- [x] AC-1.1.4: Each author type generates valid Person schema in JSON-LD

**Status:** [PASSING]

---

### 1.2 Multiple Authors Per Post
**Description:** Posts can have multiple authors of any type combination.

**Acceptance Criteria:**
- [x] AC-1.2.1: Admin can add 2+ authors to a single post
- [x] AC-1.2.2: Author order is preserved as entered
- [x] AC-1.2.3: Schema outputs `author` as array when multiple authors exist
- [x] AC-1.2.4: Schema outputs `author` as single object (not array) for single author
- [x] AC-1.2.5: Authors of different types can be mixed (WP + Custom + External)

**Status:** [PASSING]

---

### 1.3 Author Name Display Override [REQUIRED]
**Description:** Theme author byline must show assigned author(s), not WordPress post author.

**Acceptance Criteria:**
- [x] AC-1.3.1: Single custom author shows their name in theme byline (not WP user)
- [x] AC-1.3.2: Two authors display as "Name1 and Name2"
- [x] AC-1.3.3: Three authors display as "Name1, Name2 and Name3"
- [x] AC-1.3.4: Four-five authors display as comma-separated with "and" before last
- [x] AC-1.3.5: Six+ authors display as "Name1, Name2, Name3 and X others"
- [x] AC-1.3.6: Works with Kadence theme post byline
- [x] AC-1.3.7: Works with standard WordPress themes using `the_author` filter

**Status:** [PASSING] - Fixed in v1.0.6 (2026-01-15)

**Notes:** Fixed by removing gate check that prevented filters from registering. Now works with both PHP filters and JavaScript fallback.

---

### 1.4 Author Box Display
**Description:** Display author information box on posts.

**Acceptance Criteria:**
- [x] AC-1.4.1: Author box can be enabled/disabled globally per post type
- [x] AC-1.4.2: Author box can be overridden per-post
- [x] AC-1.4.3: Author box shows: image, name, job title, bio
- [x] AC-1.4.4: Multiple authors each get their own author box
- [x] AC-1.4.5: `[bw_author_box]` shortcode works for manual placement
- [x] AC-1.4.6: Position configurable: before content, after content, manual only

**Status:** [PASSING]

---

### 1.5 Custom Author Profiles
**Description:** Create and manage custom author profiles in admin.

**Required Fields:**
- Name (required)
- Job Title
- Description/Bio
- Profile Image

**Optional Fields:**
- Email, Credentials, Expertise, Affiliations, Education
- Social: Website, LinkedIn, Twitter, Facebook, Instagram, YouTube
- Team page link (internal page ID or external URL)
- Default author flag

**Acceptance Criteria:**
- [x] AC-1.5.1: Admin can create custom author with all fields
- [x] AC-1.5.2: Admin can edit existing custom authors
- [x] AC-1.5.3: Admin can delete custom authors
- [x] AC-1.5.4: One author can be marked as default (fallback)
- [x] AC-1.5.5: Profile strength indicator shows completion percentage

**Status:** [PASSING]

---

## 2. Schema Generation [REQUIRED]

### 2.1 Schema Output Format
**Description:** Output valid JSON-LD schema markup.

**Acceptance Criteria:**
- [x] AC-2.1.1: Schema outputs in `<script type="application/ld+json">` tags
- [x] AC-2.1.2: Schema appears in `wp_head` at priority 1
- [x] AC-2.1.3: Multiple schemas output as separate script tags
- [x] AC-2.1.4: HTML comments wrap output: `<!-- BW AI Schema Pro -->` ... `<!-- / BW AI Schema Pro -->`
- [x] AC-2.1.5: JSON is valid (passes Google Rich Results Test)
- [x] AC-2.1.6: JSON uses pretty print for readability

**Status:** [PASSING]

---

### 2.2 Context-Aware Schema
**Description:** Output appropriate schema based on page type.

| Page Type | Expected Schema |
|-----------|-----------------|
| Homepage | WebSite (or Organization if enabled) |
| Single Post | Article/BlogPosting (or selected type) |
| Single Page | WebPage (or selected type) |
| Author Archive | ProfilePage with Person |
| Category/Tag Archive | CollectionPage |
| Team Page | ItemList with Person items |

**Acceptance Criteria:**
- [x] AC-2.2.1: Homepage outputs WebSite schema with SearchAction
- [x] AC-2.2.2: Posts output Article schema with author, publisher, dates
- [x] AC-2.2.3: Pages output WebPage schema
- [x] AC-2.2.4: Team pages output ItemList with Person schemas
- [x] AC-2.2.5: Breadcrumb schema included on all non-homepage pages

**Status:** [PASSING]

---

### 2.3 Article Schema Types
**Description:** Support multiple Article subtypes.

| Subtype | Use Case |
|---------|----------|
| Article | Generic article |
| BlogPosting | Blog posts |
| NewsArticle | News content |
| TechArticle | Technical documentation |
| ScholarlyArticle | Academic content |

**Acceptance Criteria:**
- [x] AC-2.3.1: All five Article subtypes available in dropdown
- [x] AC-2.3.2: Subtype can be selected per-post in meta box
- [x] AC-2.3.3: Default subtype configurable per post type
- [x] AC-2.3.4: Auto-select subtype based on taxonomy term mapping

**Status:** [PASSING] - Fixed in v1.1.0 (2026-01-15)

---

### 2.4 Supported Schema Types
**Description:** Plugin supports 15 main schema types.

**Required Types:**
- [x] Article (5 subtypes)
- [x] Person (3 subtypes)
- [x] Organization (5 subtypes)
- [x] LocalBusiness (9 subtypes)
- [x] Product (5 subtypes)
- [x] Event (5 subtypes)
- [x] HowTo
- [x] FAQ
- [x] Review
- [x] Recipe
- [x] Video
- [x] Course
- [x] JobPosting
- [x] WebPage

**Acceptance Criteria:**
- [x] AC-2.4.1: All 15 types available in schema type dropdown
- [x] AC-2.4.2: Each type generates valid schema.org compliant JSON-LD
- [x] AC-2.4.3: Type-specific fields appear in Simple Mode when type selected

**Status:** [PASSING]

---

### 2.5 AI-Optimized Properties
**Description:** Include properties that help AI systems understand content.

**Property Categories:**
- Credibility: sameAs, citation, award, certification
- Expertise: knowsAbout, alumniOf, memberOf, hasCredential
- Trust: reviewedBy, factCheckedBy, lastReviewed, sourceOrganization
- Content: about, mentions, keywords, learningResourceType

**Acceptance Criteria:**
- [x] AC-2.5.1: AI property fields available in meta box
- [x] AC-2.5.2: Properties included in generated schema when filled
- [x] AC-2.5.3: Word count automatically calculated and included

**Status:** [PASSING]

---

## 3. Admin Interface [REQUIRED]

### 3.1 Setup Wizard
**Description:** 7-step guided configuration for first-time setup.

**Steps:**
1. Organization Profile
2. Leadership & Team
3. Contact & Social
4. Page Mapping
5. Content Defaults
6. Schema Features
7. Review & Complete

**Acceptance Criteria:**
- [x] AC-3.1.1: First activation redirects to setup wizard
- [x] AC-3.1.2: Progress saves between steps
- [x] AC-3.1.3: Can navigate back to previous steps
- [x] AC-3.1.4: Skip option available
- [x] AC-3.1.5: Completion status shown in dashboard

**Status:** [PASSING]

---

### 3.2 Dashboard
**Description:** Overview page showing plugin status and quick actions.

**Acceptance Criteria:**
- [x] AC-3.2.1: Shows setup completion percentage
- [x] AC-3.2.2: Shows what's configured vs missing
- [x] AC-3.2.3: Quick links to configure missing items
- [x] AC-3.2.4: Links to settings and author profiles

**Status:** [PASSING]

---

### 3.3 Post Meta Box
**Description:** Per-post schema configuration.

**Acceptance Criteria:**
- [x] AC-3.3.1: Meta box appears on configured post types
- [x] AC-3.3.2: Position configurable (normal or side)
- [x] AC-3.3.3: Simple Mode shows essential fields only
- [x] AC-3.3.4: Advanced Mode allows custom JSON-LD
- [x] AC-3.3.5: Schema preview available via AJAX
- [x] AC-3.3.6: Can disable schema for specific post
- [x] AC-3.3.7: Multiple authors selectable

**Status:** [PASSING]

---

### 3.4 Settings Page
**Description:** Global plugin settings.

**Acceptance Criteria:**
- [x] AC-3.4.1: Located under Settings > AI Schema Pro
- [x] AC-3.4.2: Organization settings configurable
- [x] AC-3.4.3: Feature toggles (breadcrumbs, search action, etc.)
- [x] AC-3.4.4: Post type defaults configurable
- [x] AC-3.4.5: Conflict management settings

**Status:** [PASSING]

---

## 4. Conflict Management [REQUIRED]

### 4.1 Schema Source Conflicts
**Description:** Disable schema from other plugins to prevent duplicates.

**Supported Sources:**
- Yoast SEO
- All in One SEO
- Rank Math
- SEOPress
- WooCommerce
- Theme schema

**Acceptance Criteria:**
- [x] AC-4.1.1: Each source listed in settings with toggle
- [x] AC-4.1.2: Disabling source removes their schema from output
- [x] AC-4.1.3: Settings persist across updates
- [x] AC-4.1.4: No errors when disabled plugin not installed

**Status:** [PASSING]

---

## 5. Caching [OPTIONAL]

### 5.1 Schema Caching
**Description:** Cache generated schemas for performance.

**Acceptance Criteria:**
- [x] AC-5.1.1: Schemas cached after generation
- [x] AC-5.1.2: Cache cleared on post save
- [x] AC-5.1.3: Cache cleared on settings update
- [x] AC-5.1.4: Cache respects WordPress object cache if available

**Status:** [PASSING]

---

## 6. Developer Extensibility [OPTIONAL]

### 6.1 Hooks and Filters
**Description:** Allow developers to customize schema output.

**Acceptance Criteria:**
- [x] AC-6.1.1: `bw_schema_[type]` filters for each schema type
- [x] AC-6.1.2: `bw_schema_rendered_schemas` filter for all schemas
- [x] AC-6.1.3: Helper methods to add custom schema types
- [x] AC-6.1.4: Helper methods to add AI properties

**Status:** [PASSING]

---

## 7. Unified People Architecture (v2.0) [PLANNED]

> **Note:** This section documents requirements for v2.0. It will supersede sections 1.1, 1.3, and 1.5 when implemented. See `docs/DESIGN-v2-authors.md` for full design.

### 7.1 Team Member as Source of Truth
**Description:** Team member CPT is the canonical record for people who appear publicly.

**Acceptance Criteria:**
- [ ] AC-7.1.1: Plugin setting to select Team Member CPT
- [ ] AC-7.1.2: Person schema data stored on team member posts
- [ ] AC-7.1.3: Schema generated from team member data (not separate storage)
- [ ] AC-7.1.4: Byline links to team member page (not WP author archive)

**Status:** [PLANNED]

---

### 7.2 Author Flag on Team Members
**Description:** Team members can be flagged as available authors.

**Acceptance Criteria:**
- [ ] AC-7.2.1: "Is Author" checkbox on team member edit screen
- [ ] AC-7.2.2: Only flagged team members appear in author selection
- [ ] AC-7.2.3: Non-author team members still get Person schema on their page

**Status:** [PLANNED]

---

### 7.3 Schema Meta Box on Team Members
**Description:** Person schema fields added to team member edit screen.

**Fields:**
- Credentials, Knows About, Awards, Same As, Alumni Of, Member Of

**Acceptance Criteria:**
- [ ] AC-7.3.1: Meta box appears on configured team CPT edit screen
- [ ] AC-7.3.2: Fields save correctly to post meta
- [ ] AC-7.3.3: Schema output includes these enhanced fields
- [ ] AC-7.3.4: Existing team CPT fields (bio, image, job title) detected and used

**Status:** [PLANNED]

---

### 7.4 Authors Section Redesign
**Description:** Authors page shows team members + external authors.

**Acceptance Criteria:**
- [ ] AC-7.4.1: Team Member Authors section shows flagged team members
- [ ] AC-7.4.2: "Edit" links to team member edit screen
- [ ] AC-7.4.3: External Authors section shows plugin-stored external authors
- [ ] AC-7.4.4: Can add new external author from this page

**Status:** [PLANNED]

---

### 7.5 Team Member ↔ WordPress User Linking
**Description:** Optional link between team member and WP user account.

**Acceptance Criteria:**
- [ ] AC-7.5.1: Dropdown on team member to select linked WP user
- [ ] AC-7.5.2: Link is optional (team members don't need WP accounts)
- [ ] AC-7.5.3: Used for author archive redirects (if enabled)

**Status:** [PLANNED]

---

### 7.6 Default Author per WordPress User
**Description:** WP users can set their default author for posts.

**Acceptance Criteria:**
- [ ] AC-7.6.1: Field on user profile: "Default author for my posts"
- [ ] AC-7.6.2: Dropdown shows team member authors + external authors
- [ ] AC-7.6.3: New posts auto-select this author
- [ ] AC-7.6.4: Can be overridden per-post

**Status:** [PLANNED]

---

### 7.7 External Authors (Reusable)
**Description:** External authors are saved and reusable across posts.

**Acceptance Criteria:**
- [ ] AC-7.7.1: External authors stored in plugin (not per-post only)
- [ ] AC-7.7.2: Can create/edit/delete from Authors page
- [ ] AC-7.7.3: Available in post author dropdown
- [ ] AC-7.7.4: Basic Person schema generated for external authors

**Status:** [PLANNED]

---

### 7.8 Migration from v1.x
**Description:** Existing custom authors migrated to new system.

**Acceptance Criteria:**
- [ ] AC-7.8.1: Migration tool detects existing custom authors
- [ ] AC-7.8.2: Option to convert to team member or external author
- [ ] AC-7.8.3: Post author references updated automatically
- [ ] AC-7.8.4: No data loss during migration

**Status:** [PLANNED]

---

## Verification Checklist

Before any release, verify all [REQUIRED] sections:

- [ ] 1.1 Author Types - all ACs pass
- [ ] 1.2 Multiple Authors - all ACs pass
- [x] 1.3 Author Name Override - all ACs pass
- [ ] 1.4 Author Box - all ACs pass
- [ ] 1.5 Custom Author Profiles - all ACs pass
- [ ] 2.1 Schema Output Format - all ACs pass
- [ ] 2.2 Context-Aware Schema - all ACs pass
- [x] 2.3 Article Schema Types - all ACs pass
- [ ] 2.4 Supported Schema Types - all ACs pass
- [ ] 3.x Admin Interface - all ACs pass
- [ ] 4.1 Conflict Management - all ACs pass

---

## Change Log for This Document

| Date | Change | By |
|------|--------|-----|
| 2026-01-15 | Initial spec created from code analysis | Claude |
| 2026-01-15 | Added Section 7: v2.0 Unified People Architecture | Rian + Claude |
