# BW AI Schema Pro - Session Log

Development session handoff notes. **Most recent session at top.**

> **For Adi (or any developer joining):** Read the latest session(s) below to see what changed. Ask Claude "summarize recent changes" if you want a quick overview.

---

## Session: 2026-01-16 (Custom Schema Override Fix)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Fix custom schema `@graph` being stripped on aisv.demoing.info

### Problem

Blog posts on aisv.demoing.info (also accessible via aismartventures.com) were showing "unspecified type" in Schema.org validator. Investigation revealed:

1. Posts had custom schema stored in `_bw_schema_custom` post meta (likely generated by an external tool)
2. The custom schema used `@graph` structure to bundle multiple types (Article, ProfessionalService, Person, Service, FAQPage)
3. When output, `@graph` was being stripped to `graph` (missing `@` symbol)

### Root Causes

1. **Security Whitelist Missing `@graph`**: The `BW_Schema_Security::is_schema_property()` whitelist included `@context`, `@type`, `@id` but NOT `@graph`. Unwhitelisted keys were passed through `sanitize_key()` which strips `@` symbols.

2. **Custom Schema Mixed with Plugin Schema**: When custom schema existed, the plugin was still outputting its own schemas (WebSite, BreadcrumbList) alongside, creating duplicates and potential conflicts.

### Fixes Applied (v2.0.2)

1. **Custom Schema Override**: When a post has `_bw_schema_custom` meta, the plugin now outputs ONLY that custom schema and skips all auto-generation. This allows external schema tools to fully control the output.
   - File: `includes/class-bw-schema-renderer.php`

2. **Added `@graph` to Whitelist**: Added `@graph` to the schema properties whitelist as a safety measure.
   - File: `includes/class-bw-schema-security.php`

### Discovered Issue: Author Override Memory Exhaustion on aisv

During testing, discovered that the `BW_Schema_Author_Override` class causes memory exhaustion (256MB limit) on aisv but NOT on rise. This is a pre-existing issue unrelated to the `@graph` fix.

**Temporary Workaround**: Disabled author override on aisv to allow the site to function.

**TODO**: Investigate why author override works on rise but causes memory issues on aisv. Possible causes:
- Different content/metadata structure
- Interaction with other plugins
- Debug logging overhead when WP_DEBUG is enabled

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-renderer.php` | Added custom schema override check at start of `render()` |
| `includes/class-bw-schema-security.php` | Added `@graph` to schema properties whitelist |
| `bw-ai-schema-pro.php` | Version bump to 2.0.2 |
| `CLAUDE.md` | Version bump |
| `docs/CHANGELOG.md` | Added v2.0.2 release notes |

### Testing

- aisv.demoing.info post with custom schema now outputs valid JSON-LD with `@graph` preserved
- Schema validator should no longer show "unspecified type" error
- Note: aismartventures.com may need Cloudflare cache purge to show updated output

### Current State

- **v2.0.2 released** with custom schema override fix
- Custom schema posts work correctly
- Author override disabled on aisv (needs investigation)
- Rise site unaffected by author override issue

### Blockers

- Author override memory issue on aisv needs investigation (low priority if author bylines not needed)

---

## Session: 2026-01-15 (Post-v2.0 Bug Fixes)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Fix issues discovered during testing after v2.0 release

### What Was Fixed

1. **Page mappings not reflecting in schema output**
   - **Symptom:** Pages mapped in wizard Step 4 (About → AboutPage, Contact → ContactPage) were not outputting their assigned schema types
   - **Cause:** `get_schema_type_for_post()` didn't check `bw_schema_page_mappings` option
   - **Fix:** Added `get_schema_type_from_page_mapping()` method to `BW_Schema_Core`
   - Page mapping now checked in priority order: post meta > **page mapping** > taxonomy mapping > post type default
   - File: `includes/class-bw-schema-core.php`

2. **Leadership in Review tab using old founders data**
   - **Symptom:** Review tab showed "John Garcia" from legacy `bw_schema_founders` option, not team members with "Is Leader" flag
   - **Fix:** Updated Review tab to query team members with `_bw_schema_is_leader = '1'`
   - Also updated schema preview to use team members for founder property
   - File: `admin/views/setup-wizard.php`

3. **Organization schema not using Is Leader flag**
   - **Symptom:** Organization schema on homepage was still using legacy `bw_schema_founders` option
   - **Fix:** Updated renderer to query team members with Is Leader flag, with fallback to legacy option
   - Leaders now include proper Person schema with `@id` reference to their team page
   - File: `includes/class-bw-schema-renderer.php`

4. **Areas Served and Services Offered missing from wizard**
   - **Symptom:** These fields were only available in advanced Settings page, not in the wizard
   - **Fix:** Added both fields to wizard Step 1 (Organization Profile) under Business Details
   - Save handler updated to process these fields
   - Schema preview in Review tab updated to show these properties
   - Files: `admin/views/setup-wizard.php`, `includes/class-bw-schema-admin.php`

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-core.php` | Added `get_schema_type_from_page_mapping()` method, updated `get_schema_type_for_post()` priority |
| `includes/class-bw-schema-renderer.php` | Updated founder section to use team members with Is Leader flag |
| `admin/views/setup-wizard.php` | Updated Review tab to show team members, added areas served/services fields |
| `includes/class-bw-schema-admin.php` | Added save handler for areas served/services in Step 1 |
| `docs/CHANGELOG.md` | Added unreleased section with these fixes |

### Testing Notes

- About page (`/about/`) now outputs `AboutPage` schema type ✅
- Contact page (`/contact/`) now outputs `ContactPage` schema type ✅
- Team page outputs `ItemList` of `Person` (specialized handling - correct behavior)
- Step 6 options (enable_schema, enable_breadcrumbs, etc.) are all saving correctly ✅

### Current State

All reported issues resolved. Plugin is stable.

### Blockers

None.

---

## Session: 2026-01-15 (v2.0 Phase 4 - Author Box & URLs)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Complete Phase 4 - Author box improvements, byline links, author archive redirects

### Critical Bug Fixes (Later Session)

7. **Fixed Infinite Recursion / Memory Exhaustion**
   - **Symptom:** Pages took 24+ seconds, 500 errors, 268MB memory exhaustion
   - **Cause:** `get_the_excerpt()` in author box triggered `the_content` filter recursively
   - **Fix:** Added static `$is_rendering` flag in `maybe_add_author_box()` to prevent recursion
   - **Result:** Pages now load in 0.3-0.5 seconds
   - File: `includes/class-bw-schema-author-box.php`

8. **Fixed Legacy Author Type URLs**
   - **Symptom:** Posts with legacy `custom` or `wordpress` author types had no byline links
   - **Cause:** `filter_author_url()` switch only had v2.0 types, missing legacy cases
   - **Fix:** Added `custom` and `wordpress` cases to handle legacy authors
   - File: `includes/class-bw-schema-author-override.php`

9. **Fixed Kadence Theme Byline Links**
   - **Symptom:** Kadence byline showed author name but no link
   - **Cause:** `filter_kadence_author_output()` deliberately stripped links (old comment said "just show names without links")
   - **Fix:** Updated to use `format_author_names($author_names, true, $multiple_authors)` to include links
   - File: `includes/class-bw-schema-author-override.php`

10. **Fixed Internal vs External Link Handling**
    - **Symptom:** All author links opened in new tab with `target="_blank"`
    - **Fix:** Added `$is_external` tracking in `format_author_names()`:
      - Internal links (team_member, wordpress, custom with teamPageId): same window
      - External links (external_saved, external, custom with website): new tab
    - File: `includes/class-bw-schema-author-override.php`

11. **Added Static Caching to User-Team Lookups**
    - Added static `$cache` array to `get_team_member_for_user()` methods
    - Prevents duplicate database queries when checking same user multiple times
    - Files: `includes/class-bw-schema-author-override.php`, `includes/class-bw-schema-author-box.php`

### What Was Done

1. **Updated Author Box for v2.0 Author Types**
   - Added support for `team_member` and `external_saved` author types in author box
   - Author box now uses v2.0 plugin-wide default author as fallback
   - Added `get_team_member_for_user()` helper method
   - File: `includes/class-bw-schema-author-box.php`

2. **Simplified Author Box Visual Design**
   - Removed bio section from author box
   - Removed debug information
   - Compact single-line layout: avatar (48px) + name (linked) + job title
   - Clean, minimal styling with smaller padding
   - File: `assets/css/author-box.css` (complete rewrite)

3. **Updated Per-Post Author Box Settings**
   - Changed from checkbox (show/hide) to radio buttons (3 options)
   - Options: "Use Default", "Show Author Box", "Don't Show Author Box"
   - Migration for legacy values: 'yes' → 'show', 'no' → 'hide'
   - File: `includes/class-bw-schema-admin.php` (meta box rendering)
   - File: `bw-ai-schema-pro.php` (save handler)

4. **Fixed Byline Links to Team Pages**
   - `filter_get_author_link()` now handles single authors (was only multiple)
   - `filter_author_url()` updated for v2.0 author types
   - Team member authors link to their team page
   - External saved authors can have custom URLs
   - WP users with linked team members link to team page
   - File: `includes/class-bw-schema-author-override.php`

5. **Added Author Archive 301 Redirects**
   - New `maybe_redirect_author_archive()` method
   - When visiting `/author/username/`, redirects to team page if user has linked team member
   - Configurable via new setting (default: enabled)
   - File: `bw-ai-schema-pro.php` (redirect logic)

6. **Added Author Archive Redirect Setting UI**
   - New checkbox in Settings → Author Box Settings section
   - "Redirect Author Archives to Team Pages"
   - Stored in `bw_schema_redirect_author_archives` option
   - File: `admin/views/settings.php`
   - File: `includes/class-bw-schema-admin.php` (save handler)

### Data Storage

```php
// Per-post author box display
get_post_meta($post_id, '_bw_schema_show_author_box', true)
// Values: 'default', 'show', 'hide' (legacy: 'yes', 'no')

// Author archive redirect setting
get_option('bw_schema_redirect_author_archives', 'yes')
// Values: 'yes', 'no'
```

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-author-box.php` | v2.0 author types, plugin default fallback, simplified rendering |
| `assets/css/author-box.css` | Complete rewrite - compact, minimal design |
| `includes/class-bw-schema-admin.php` | Radio buttons for author box options, redirect save handler |
| `bw-ai-schema-pro.php` | Save handler update, redirect method + hook |
| `includes/class-bw-schema-author-override.php` | Fixed single author links, v2.0 author type handling |
| `admin/views/settings.php` | Author archive redirect checkbox |

### Testing Notes

- View any post with assigned author → Byline should link to team page (if team member author)
- View author archive `/author/username/` → Should 301 redirect to team page (if linked)
- Settings → Author Box Settings → Redirect checkbox should be present
- Post editor → Author Box Display should show 3 radio options
- Author box at bottom of post should be compact (avatar + name + title only)

### Current State

**All v2.0 Phases COMPLETE:**
- ✅ Phase 1: Team Member CPT as source of truth
- ✅ Phase 2: ProfilePage + Person schema generation
- ✅ Phase 3: Author Management redesign
- ✅ Phase 4: Author box, byline links, archive redirects
- ✅ Phase 5: Setup Wizard People step, Migration tool

**v2.0.0 Released!**

### What Was Completed in Phase 5

12. **Redesigned Setup Wizard Step 2 as "People"**
    - Moved team post type configuration from Step 6
    - Added Team Members overview table (Is Author, Is Leader, Linked WP User)
    - Added WordPress Users & Default Authors table
    - Shows migration notice when legacy custom authors exist
    - Kept Awards & Certifications as organization-level

13. **Built Legacy Custom Author Migration Tool**
    - Shows on Authors admin page when legacy authors exist
    - Auto-matches by name to existing team members
    - Options: Link to team member, convert to external, delete, or skip
    - Automatically updates post `_bw_schema_multiple_authors` references
    - Counts posts using each legacy author

### Files Modified in Phase 5

| File | Change |
|------|--------|
| `admin/views/setup-wizard.php` | Step 2 redesigned as People step, team_post_type removed from Step 6 |
| `admin/views/author-profiles.php` | Added migration tool UI |
| `includes/class-bw-schema-admin.php` | New Step 2 save handler, migration processing methods |
| `bw-ai-schema-pro.php` | Version updated to 2.0.0 |
| `docs/CHANGELOG.md` | Added v2.0.0 release notes |
| `CLAUDE.md` | Updated version to 2.0.0 |

### Next Steps

v2.0.0 is complete. Future work:
- Monitor for any edge cases in author migration
- Consider adding more schema types to taxonomy mapping
- Address any user feedback

### Blockers

None.

---

## Session: 2026-01-15 (v2.0 Plugin-wide Default Author)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Add plugin-wide default author fallback setting

### What Was Done

1. **Added Plugin-wide Default Author UI**
   - New "Plugin Default Author" section on Authors admin page
   - Dropdown to select a Team Member or External Author as the default
   - Displays current default author with visual confirmation
   - File: `admin/views/author-profiles.php`

2. **Added Save Handler**
   - Validates selected author exists and is valid (team member flagged as author, or external author in storage)
   - Stores in `bw_schema_plugin_default_author` option as `{type, id}`
   - Shows success/cleared notice
   - File: `includes/class-bw-schema-admin.php` - `save_plugin_default_author()`

3. **Updated Author Default Chain**
   - New post author pre-selection now follows chain:
     1. User's personal default author (`bw_schema_default_author` user meta)
     2. Plugin-wide default author (`bw_schema_plugin_default_author` option)
     3. First available author type (team_member if available, else external)
   - File: `includes/class-bw-schema-admin.php` - `render_author_field()`

4. **Updated Dashboard Display**
   - Dashboard now shows v2.0 plugin-wide default author
   - Legacy `isDefault` system preserved as fallback
   - File: `admin/views/dashboard.php`

5. **Fixed Job Title "Array" Bug**
   - `BW_Schema_Team_Member::detect_job_title()` returns array with `['value', 'source', 'meta_key']`
   - Fixed 3 locations that were outputting the array instead of extracting `value`
   - Files: `bw-ai-schema-pro.php`, `admin/views/author-profiles.php`, `includes/class-bw-schema-admin.php`

### Data Storage

```php
// Plugin-wide default author
get_option('bw_schema_plugin_default_author')
// Returns: ['type' => 'team_member'|'external', 'id' => post_id|ext_key]
```

### Files Modified

| File | Change |
|------|--------|
| `admin/views/author-profiles.php` | Added default author UI section, fixed job title array bug |
| `includes/class-bw-schema-admin.php` | Added `save_plugin_default_author()`, updated author fallback chain, fixed job title array bug |
| `admin/views/dashboard.php` | Updated to show v2.0 default author, legacy fallback |
| `bw-ai-schema-pro.php` | Fixed job title array bug in user profile dropdown |

### Testing Notes

- Go to Authors page → Plugin Default Author section should appear
- Select a Team Member or External Author → Save Default
- Dashboard should show the selected default author
- Create new post → Author should pre-select the plugin default (if no user default set)

---

## Session: 2026-01-15 (v2.0 Phase 3 - Post Author Selection UI)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Complete Phase 3 of v2.0 - Author Selection UI in Meta Box

### What Was Done

1. **Redesigned Post Author Selection UI**
   - Replaced old author type system (WordPress User, Custom Author, External)
   - New v2.0 types: Team Member Author, External Author (saved), External (One-time)
   - Team Member Authors: sourced from Team CPT where `_bw_schema_is_author = '1'`
   - External Authors (saved): from `bw_schema_external_authors` plugin option
   - External (One-time): inline form for ad-hoc authors (unchanged)
   - File: `includes/class-bw-schema-admin.php` - `render_author_field()` method

2. **Added Default Author Pre-selection**
   - When editing a new post, author dropdown pre-selects user's default author
   - Uses `bw_schema_default_author` user meta (set in Phase 3 part 1)
   - Only applies to first author slot (index 0) when no existing data

3. **Updated Author Save Logic**
   - Added `team_member` and `external_saved` type handling in post save
   - `team_member` stores `team_member_id` (post ID)
   - `external_saved` stores `external_author_id` (option key)
   - Legacy types (`wordpress`, `custom`, `external`) preserved for backwards compat
   - File: `bw-ai-schema-pro.php` - save_post handler

4. **Updated Author Override Display**
   - All 8 switch statements in author override class updated for new types
   - Team member authors resolved to team member post title
   - External saved authors resolved from `bw_schema_external_authors` option
   - File: `includes/class-bw-schema-author-override.php`

5. **Updated Schema Generation**
   - Added `team_member` and `external_saved` cases to schema author generation
   - Team members use existing `get_team_member_author_schema()` method
   - Created new `get_external_saved_author_schema()` method
   - File: `includes/schemas/class-bw-schema-base.php`

6. **Updated JavaScript for Dynamic Author Types**
   - JavaScript now uses first available type as default when adding authors
   - No longer hardcoded to 'wordpress' type
   - File: `includes/class-bw-schema-admin.php` - inline JS

### New Author Type System

| Type | Source | Storage Key |
|------|--------|-------------|
| `team_member` | Team CPT (flagged as author) | `team_member_id` |
| `external_saved` | Plugin external authors option | `external_author_id` |
| `external` | One-time inline form | `external` array |
| `wordpress` (legacy) | WordPress Users | `wordpress_user_id` |
| `custom` (legacy) | Custom Authors option | `custom_author_id` |

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-admin.php` | Rewrote `render_author_field()` (~200 lines), updated JS default type |
| `bw-ai-schema-pro.php` | Added `team_member` and `external_saved` to save handler |
| `includes/class-bw-schema-author-override.php` | Updated 8 switch statements for new author types |
| `includes/schemas/class-bw-schema-base.php` | Added `get_external_saved_author_schema()`, updated author type handling |

### Testing Notes

- Create/edit post → Author dropdown should show Team Member Authors and External Authors
- New posts should pre-select user's default author (if set)
- Author byline on frontend should display team member/external author names
- Schema output should include correct Person schema for all author types

### Phase 3 Complete

All three parts of Phase 3 are now complete:
- ✅ Authors admin page redesign (team member + external authors)
- ✅ Default Author user profile field
- ✅ Post author selection UI update

---

## Session: 2026-01-16 (v2.0 Phase 2 - ProfilePage Schema + Bug Fixes)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Implement Phase 2 ProfilePage schema and fix critical bugs preventing schema output

### What Was Done

1. **Fixed Critical Bug: Schema Not Outputting on Team Pages**
   - **Root Cause:** `remove_remaining_schemas()` was removing our own `output_schema_markup` hook
   - Hook keys for object callbacks are hash + method name (e.g., `00000000000007090000000000000000output_schema_markup`)
   - Key contained "schema" but NOT `BW_AI_Schema_Pro` class name
   - **Fix:** Added `output_schema_markup` to preservation check in `remove_remaining_schemas()`
   - File: `includes/class-bw-schema-team-member.php` lines 1269-1274

2. **Fixed Bug: Schema Property Names Lowercased**
   - **Root Cause:** `BW_Schema_Security::sanitize_output()` uses `sanitize_key()` on unrecognized keys
   - `sanitize_key()` lowercases strings
   - Missing properties: `honorificPrefix`, `honorificSuffix`, `credentialCategory`, `recognizedBy`, `subjectOf`
   - **Fix:** Added missing properties to `$schema_properties` whitelist
   - File: `includes/class-bw-schema-security.php` lines 196-197

3. **Implemented Phase 2: ProfilePage + Person Schema**
   - Team member pages now output `ProfilePage` as top-level type
   - `mainEntity` contains full Person schema with `@id` reference
   - Person schema includes all v2.0 fields: credentials, video, honorifics, etc.
   - Added employee array to Organization schema on homepage (reciprocal linking)

4. **Phase 1 Polish: Structured Credentials and Video**
   - Credentials now output as `EducationalOccupationalCredential` objects
   - `credentialCategory`: degree, certification, professional
   - `recognizedBy` with CollegeOrUniversity or Organization type
   - Video outputs as `VideoObject` via `subjectOf` property

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-team-member.php` | Fixed hook preservation, added structured credentials/video UI (~100 lines) |
| `includes/class-bw-schema-renderer.php` | Added ProfilePage schema generation, employee array in Organization |
| `includes/class-bw-schema-security.php` | Added missing schema.org properties to whitelist |

### Technical Details

**ProfilePage Schema Structure:**
```json
{
  "@type": "ProfilePage",
  "@id": "https://example.com/team/person/",
  "mainEntity": {
    "@type": "Person",
    "@id": "https://example.com/team/person/#person",
    "name": "...",
    "worksFor": { "@id": "https://example.com/#organization" },
    "hasCredential": [ { "@type": "EducationalOccupationalCredential", ... } ],
    "subjectOf": { "@type": "VideoObject", ... }
  }
}
```

### Current State

- **Phase 1:** Complete ✅
- **Phase 2:** Complete ✅
- Schema correctly outputs on team member pages
- All property names in correct camelCase
- Reciprocal linking working (Person → Organization, Organization → Person[])

### Next Steps

1. **Phase 3: Author Management** - Authors section redesign, default author per WP user
2. **Phase 4: URL & Redirects** - Bylines link to team pages, 301 redirects
3. **Phase 5: Wizard & Migration** - New People step, migration tool

### Blockers

None.

---

## Session: 2026-01-15 (v2.0 Phase 1 - Team Member Schema)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Implement v2.0 Phase 1 - Team Member CPT as source of truth for Person schema

### What Was Done

1. **Implemented configurable Team Post Type**
   - Added `get_team_post_type()` method that checks plugin settings
   - Falls back to `bw_schema_team_post_type` option
   - Returns `false` if not configured (graceful degradation)

2. **Added Core Fields section to meta box**
   - Shows auto-detected values for: Name, Job Title, Description, Image, URL
   - Each field shows source (post title, meta key, excerpt, featured image, permalink)
   - Override inputs allow customizing schema output without changing source data
   - `detect_job_title()` tries 9+ common meta keys (job_title, position, role, etc.)

3. **Added Organization (worksFor) field**
   - Defaults to site organization with `@id` reference
   - Override field allows specifying different organization
   - Handles edge case: team member works for external org

4. **Added Honorific fields**
   - `honorificPrefix` (Dr., Prof., Mr., Ms.)
   - `honorificSuffix` (Jr., III, Esq.)
   - Both saved as post meta and output in Person schema

5. **Updated `get_person_schema_data()` method**
   - Checks for overrides first, falls back to detected values
   - Includes worksFor with @id reference to organization
   - Includes honorificPrefix/Suffix when set
   - Returns complete Person schema data ready for JSON-LD

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-team-member.php` | Added Core Fields UI, save handlers, schema methods (~200 lines) |
| `docs/SESSION-LOG.md` | This entry |

### Technical Details

**New post meta keys:**
- `_bw_schema_override_name` - Override detected name
- `_bw_schema_override_job_title` - Override detected job title
- `_bw_schema_override_description` - Override excerpt
- `_bw_schema_override_image` - Override featured image URL
- `_bw_schema_override_url` - Override permalink
- `_bw_schema_override_organization` - Override worksFor org name
- `_bw_schema_honorific_prefix` - Dr., Prof., etc.
- `_bw_schema_honorific_suffix` - Jr., III, Esq.

**Job title detection priority:**
1. Configured custom meta key (`bw_schema_job_title_meta_key` option)
2. Common meta keys: job_title, _job_title, position, title, role, job-title, jobtitle, team_position, member_position

### Current State

- **Phase 1 is COMPLETE**
- Team member edit screen now has "Person Schema Settings" meta box
- Core fields display with override capability
- Is Author / Is Leader flags working
- WordPress User linking working
- All schema enhancement fields working (credentials, knowsAbout, sameAs, awards, alumniOf, memberOf)
- Honorific fields working

### Next Steps

1. **Phase 2: Schema Generation** - ProfilePage + Person output, worksFor/employee reciprocal linking
2. **Phase 3: Author Management** - Authors section redesign
3. **Phase 4: URL & Redirects** - Bylines link to team pages, 301 redirects
4. **Phase 5: Wizard & Migration** - New People step, migration tool

### Notes for Next Session

- Team post type must be configured in plugin settings for Phase 1 features to work
- The meta box only appears on the configured team post type
- Overrides are optional - empty fields fall back to detected values
- Phase 2 will add the actual ProfilePage + Person schema output

### Blockers

None.

---

## Session: 2026-01-15 (ISSUE-002 - Taxonomy Schema Mapping)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Implement taxonomy-based schema type mapping (v1.1.0 release)

### What Was Done

1. **Discussed implementation approach**
   - User wanted to assign schema types based on taxonomy terms (not just post type)
   - Example: Resources post type with "Case Study" term → TechArticle schema
   - Decided to implement as v1.1.0 before the larger v2.0 refactor

2. **Added core methods to `class-bw-schema-core.php`**
   - `get_taxonomy_mappings()` - Retrieves taxonomy-to-schema mappings from options
   - `update_taxonomy_mappings()` - Saves mappings
   - `get_schema_type_for_post()` - Centralized method with priority order:
     1. Post-specific meta override (`_bw_schema_type`)
     2. Taxonomy term mapping (NEW)
     3. Post type default
     4. Fallback (`article:Article`)
   - `get_schema_type_from_taxonomy()` - Looks up schema type from post's taxonomy terms

3. **Updated `class-bw-schema-renderer.php`**
   - Changed to use new centralized `BW_Schema_Core::get_schema_type_for_post()` method
   - Removed duplicate logic that was inline

4. **Added UI to Setup Wizard Step 5 (Content Defaults)**
   - New fieldset "Taxonomy-Based Schema Override"
   - Shows post types that have taxonomies
   - Taxonomy selector dropdown per post type
   - Term mapping table with schema type dropdowns
   - AJAX loads terms when taxonomy selected

5. **Added save handler in `class-bw-schema-admin.php`**
   - Processes `taxonomy_mappings` POST data in Step 5 handler
   - Sanitizes and stores in `bw_schema_taxonomy_mappings` option

6. **Tested with Resources post type**
   - Configured: `resource-type` taxonomy with term mappings
   - Case Studies (`case-studies`) → `article:TechArticle` ✅
   - News (`news`) → `article:NewsArticle` ✅
   - Unmapped terms → post type default ✅

7. **Updated documentation**
   - KNOWN-ISSUES.md: Moved ISSUE-002 to Resolved Issues with full details
   - CHANGELOG.md: Added v1.1.0 entry with both fixes
   - SPEC.md: Marked AC-2.3.4 as passing, updated checklist
   - CLAUDE.md: Updated to show no active issues
   - SESSION-LOG.md: This entry

### Files Modified

| File | Change |
|------|--------|
| `bw-ai-schema-pro.php` | Updated version to 1.1.0 |
| `includes/class-bw-schema-core.php` | Added taxonomy mapping methods (~80 lines) |
| `includes/class-bw-schema-renderer.php` | Updated to use centralized method |
| `admin/views/setup-wizard.php` | Added taxonomy mapping UI in Step 5 (~100 lines) |
| `includes/class-bw-schema-admin.php` | Added save handler for taxonomy mappings |
| `docs/KNOWN-ISSUES.md` | Documented ISSUE-002 resolution |
| `docs/CHANGELOG.md` | Added v1.1.0 release notes |
| `docs/SPEC.md` | Marked AC-2.3.4 passing, updated version |
| `CLAUDE.md` | Updated status, version, removed active issues |
| `docs/SESSION-LOG.md` | This entry |

### Current State

- **v1.1.0 is complete and released**
- Both ISSUE-001 and ISSUE-002 are resolved
- All acceptance criteria in SPEC.md Section 2.3 now pass
- Plugin is stable for production use

### Technical Details

**New option structure** (`bw_schema_taxonomy_mappings`):
```php
[
    'resource' => [
        'taxonomy' => 'resource-type',
        'term_mappings' => [
            'case-studies' => 'article:TechArticle',
            'news' => 'article:NewsArticle',
        ]
    ]
]
```

**Priority order for schema type determination:**
1. Post-specific meta (`_bw_schema_type`) - highest priority
2. Taxonomy term mapping - NEW in v1.1.0
3. Post type default (`bw_schema_post_type_defaults`)
4. Fallback (`article:Article`)

**Filter available:** `bw_schema_taxonomy_mappings` - allows developers to modify mappings programmatically

### Next Steps

1. **v2.0 Planning** - The unified People/Team/Authors architecture is designed but not yet implemented
2. Consider user feedback on the new taxonomy mapping feature
3. May need to add more schema types to the mapping dropdown if requested

### Notes for Next Session

- The taxonomy mapping UI only shows post types that have taxonomies
- First matching term wins (if a post has multiple terms with mappings)
- Unmapped terms fall back to post type default, not to generic Article
- The `bw_schema_use_custom_authors` option now only controls UI display in meta box

### Blockers

None.

---

## Session: 2026-01-15 ~23:30 (ISSUE-001 Fix)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Fix ISSUE-001 - Author name override regression

### What Was Done

1. **Investigated author override failure**
   - Found that `bw_schema_use_custom_authors` option was set to `'no'`
   - This caused the `init()` method to return early without registering any filters
   - Posts had custom authors assigned but byline still showed WP user

2. **Root cause identified**
   - Line 20 of `class-bw-schema-author-override.php` had gate check:
     ```php
     if ( get_option( 'bw_schema_use_custom_authors', 'no' ) !== 'yes' ) {
         return; // Never registered filters!
     }
     ```
   - This was a design flaw: users could assign custom authors but override wouldn't work unless global setting was 'yes'

3. **Fix applied**
   - Removed gate check - filters now always register
   - Extended JavaScript fallback to run for single custom authors (not just multiple)
   - Added WordPress author name to JS matching for more reliable replacement

4. **Tested and verified**
   - Created test post with custom author "Aaron Todrin"
   - JSON-LD schema correctly shows "Aaron Todrin"
   - Theme byline HTML shows "Aaron Todrin" (PHP filters working)
   - JavaScript fallback present as backup

5. **Updated documentation**
   - KNOWN-ISSUES.md: Moved ISSUE-001 to "Resolved Issues"
   - CHANGELOG.md: Added v1.0.6 release notes
   - SPEC.md: Marked AC-1.3.x criteria as passing
   - CLAUDE.md: Updated critical issues section

### Files Modified

| File | Change |
|------|--------|
| `includes/class-bw-schema-author-override.php` | Removed gate check (lines 18-27), extended JS fallback (lines 1134-1198) |
| `docs/KNOWN-ISSUES.md` | Moved ISSUE-001 to Resolved Issues |
| `docs/CHANGELOG.md` | Added v1.0.6 entry |
| `docs/SPEC.md` | Marked Section 1.3 as PASSING |
| `CLAUDE.md` | Updated critical issues |
| `docs/SESSION-LOG.md` | This entry |

### Current State

- ISSUE-001 is **FIXED** (v1.0.6)
- ISSUE-002 (category-based schema types) remains open
- v2.0 architecture designed but not implemented

### Next Steps

1. Consider implementing ISSUE-002 (category-based schema types)
2. Or proceed with v2.0 architecture implementation

### Notes for Next Session

- The `bw_schema_use_custom_authors` option now only controls what the meta box shows (custom authors dropdown vs WP users dropdown)
- Author override works based on post meta, not global setting
- Data inconsistency found: some posts had mismatched custom_author_id values (old format vs new format)

### Blockers

None.

---

## Session: 2026-01-15 14:00 (Continued)

**User:** rian
**Developer:** Rian + Claude
**Focus:** Documentation overhaul + v2.0 Architecture Design

### What Was Done

#### Part 1: Documentation Overhaul

1. **Created backup** of plugin before changes
   - Location: `/srv/apps/rise/wp-content/plugins/bw-ai-schema-pro-backup-20260115-135032.zip`

2. **Analyzed existing documentation**
   - Reviewed `PLUGIN-DOCUMENTATION.md` (490 lines)
   - Reviewed `TEAM-SCHEMA-GUIDE.md` (165 lines)
   - Reviewed `bw-ai-schema-pro-todo.md` (343 lines)

3. **Explored codebase** to understand current functionality
   - Main features and hooks
   - Schema output system (15 types, 30+ subtypes)
   - Author management system (3 author types)

4. **Created new documentation structure**
   - `CLAUDE.md` - Quick reference for AI development (with Session Start Protocol)
   - `docs/SPEC.md` - Feature requirements with acceptance criteria
   - `docs/KNOWN-ISSUES.md` - Bug tracking (2 issues documented)
   - `docs/CHANGELOG.md` - Version history (1.0.0 through 1.0.5)
   - `docs/ROADMAP.md` - Future work prioritized
   - `docs/ARCHITECTURE.md` - Technical reference
   - `docs/SESSION-LOG.md` - This file
   - `docs/TESTING.md` - Verification checklists

5. **Cleaned up old files**
   - Moved `TEAM-SCHEMA-GUIDE.md` → `docs/guides/team-schema.md`
   - Deleted `PLUGIN-DOCUMENTATION.md`
   - Deleted `bw-ai-schema-pro-todo.md`

6. **Added Session Start Protocol to CLAUDE.md**
   - Claude now summarizes changes for returning users
   - Tracks per-user sessions for handoffs

#### Part 2: v2.0 Architecture Design

7. **Discussed author/team/user architecture problems**
   - Tom exists in 4 places (WP User, Team Member, Custom Author, per-post)
   - No single source of truth
   - Bylines link to WP author archive, not team page
   - Schema disconnected from profiles

8. **Designed v2.0 Unified People Architecture**
   - Team Member CPT = source of truth for public people
   - Schema fields added to team member edit screen
   - "Is Author" flag on team members
   - Authors section shows team members, not separate custom authors
   - External Authors (reusable) for guest contributors
   - WP User can have "Default Author" setting (Jenny posts → Tom as author)
   - Team Member can link to WP User (optional)

9. **Created documentation for v2.0**
   - `docs/DESIGN-v2-authors.md` - Full design document
   - Updated `docs/ROADMAP.md` - Added v2.0.0 milestone
   - Updated `docs/SPEC.md` - Added Section 7 with v2.0 requirements

### Files Created/Modified

| File | Action | Purpose |
|------|--------|---------|
| `CLAUDE.md` | Created | AI orientation with Session Start Protocol |
| `docs/SPEC.md` | Created + Updated | Feature specs, added v2.0 section |
| `docs/KNOWN-ISSUES.md` | Created | Bug tracking |
| `docs/CHANGELOG.md` | Created | Version history |
| `docs/ROADMAP.md` | Created + Updated | Added v2.0.0 milestone |
| `docs/ARCHITECTURE.md` | Created | Technical reference |
| `docs/SESSION-LOG.md` | Created | Session handoffs |
| `docs/TESTING.md` | Created | Test checklists |
| `docs/DESIGN-v2-authors.md` | Created | v2.0 architecture design |
| `docs/guides/team-schema.md` | Moved | From root |

### Current State

- Documentation structure complete
- v2.0 architecture designed and documented
- Ready to implement (either v1.1 bug fixes or v2.0 architecture)

### Next Steps

**Option A: Fix v1.1 issues first**
1. Fix author name override (ISSUE-001)
2. Add category-based schema types (ISSUE-002)
3. Then proceed to v2.0

**Option B: Jump to v2.0**
1. Implement v2.0 architecture (will fix ISSUE-001 as part of it)
2. Category-based types can be added during or after

**Decision needed from Rian.**

### Notes for Adi

- Major documentation overhaul completed
- v2.0 architecture designed - see `docs/DESIGN-v2-authors.md`
- This changes how authors work fundamentally:
  - Team members become the source of truth
  - Custom Authors section goes away
  - External Authors section added for guest contributors
- Read `CLAUDE.md` and `docs/DESIGN-v2-authors.md` before starting work

### Blockers

None currently.

---

## Session Template

Copy this template for new sessions:

```markdown
## Session: YYYY-MM-DD HH:MM

**User:** linux_username
**Developer:** Name + Claude
**Focus:** Brief description

### What Was Done
- Item 1
- Item 2

### Current State
Description of where things stand.

### Files Modified
| File | Change |
|------|--------|
| `file.php` | Description |

### Next Steps
1. Step 1
2. Step 2

### Notes for Next Session
- Note 1
- Note 2

### Blockers
- Blocker or "None"
```

---

## Session Archive

*Move older sessions here after 5+ newer sessions to keep the log manageable.*
