# BW AI Schema Pro - Roadmap

**Last Updated:** 2026-01-15

This document outlines planned features and improvements, prioritized by version.

---

## Version 1.1.0 ✅ RELEASED (2026-01-15)

**Focus:** Bug fixes and critical enhancements

### Completed

- [x] **Fix author name override regression** (ISSUE-001)
  - Removed gate check that prevented filter registration
  - Extended JavaScript fallback for single custom authors
  - Theme byline now correctly shows custom/multiple authors

- [x] **Taxonomy-based schema type mapping** (ISSUE-002)
  - Added taxonomy mapping UI in Setup Wizard Step 5
  - Auto-select Article subtype based on taxonomy terms
  - Filterable via `bw_schema_taxonomy_mappings`
  - Priority: post meta > taxonomy mapping > post type default > fallback

### Moved to Backlog

- [ ] **Case Study schema support** - Can now use TechArticle via taxonomy mapping
- [ ] **Webinar schema support** - Event type already available

---

## Version 2.0.0 (Major Release)

**Focus:** Unified People/Author Architecture

This is a significant architectural change that unifies team members, authors, and WordPress users into a coherent system. See `docs/DESIGN-v2-authors.md` for full design document.

### Phase 1: Foundation ✅ COMPLETE

- [x] **Team Member as Source of Truth**
  - Configurable Team Member CPT (plugin setting)
  - All person/author data lives on team member posts
  - Core fields with override capability (name, job title, description, image, URL)
  - Organization (worksFor) with override for external team members
  - Honorific prefix/suffix fields

- [x] **Schema Fields on Team Members**
  - Add Person schema meta box to team member edit screen
  - Fields: credentials, knowsAbout, awards, sameAs, alumniOf, memberOf
  - "Is Author" and "Is Leader" flag checkboxes

- [x] **Team Member ↔ WordPress User Linking**
  - Optional link from team member to WP User
  - Completes the identity loop

### Phase 2: Schema Generation ✅ COMPLETE

- [x] **ProfilePage + Person Schema for Team Pages**
  - Team member pages output `ProfilePage` as top-level type
  - `mainEntity` contains the `Person` schema with `@id` reference
  - This tells Google "this page is a profile about this person"

- [x] **Reciprocal Linking (worksFor/employee)**
  - Person schema includes `worksFor` → Organization reference
  - Organization schema includes `employee` → Person array with `@id` references
  - Creates bidirectional knowledge graph for better SEO

- [x] **Article Author Schema**
  - Article `author` property references Person schema with `@id`
  - Person `url` links to team page (not WP author archive)
  - Works with both multiple authors system and legacy single author

### Phase 3: Author Management

- [ ] **Authors Section Redesign**
  - Shows team members where Is Author = true
  - "Edit" links to team member edit screen (not separate form)
  - Plus section for External Authors (reusable guest contributors)

- [ ] **Default Author per WordPress User**
  - WP User settings: "Default author for my posts"
  - Jenny (admin) can have her posts default to Tom (author)
  - Can be overridden per-post

- [ ] **Post Author Selection UI**
  - Dropdown with: Team Member Authors, External Authors
  - Default pre-selected based on current user's settings

### Phase 4: URL & Redirect Handling

- [ ] **Byline Links to Team Pages**
  - Author name in byline links to team member page
  - Not to WP author archive (`/author/username/`)

- [ ] **Author Archive 301 Redirects**
  - Auto-redirect `/author/username/` to team page (enabled by default)
  - New setting: "Redirect Author Archives to Team Member pages"
  - Consolidates link equity on team pages (better SEO)

### Phase 5: Setup Wizard & Migration

- [ ] **Setup Wizard Redesign**
  - Remove "Leadership & Team" step (Step 2)
  - Add "People" step (new Step 5, after Content)
  - "At a glance" view: team members, WordPress users, default authors

- [ ] **Leadership from Team Members**
  - "Is Leader" flag on team members
  - Leaders appear in Organization founders schema
  - No separate leadership storage

- [ ] **Migration Tool**
  - Migrate existing custom authors to team members (or external)
  - Preserve existing post-author relationships
  - Backward compatibility for existing schema output

### Benefits

- Single source of truth for people
- Bylines automatically link to team pages
- Schema lives with the profile (not separate)
- Simpler mental model for content editors
- Jenny can post without being displayed as author

---

## Version 2.1.0 (Post-2.0 Enhancements)

**Focus:** Refinements after v2.0 architecture

### Planned

- [ ] User account fallback (if no team CPT configured)
- [ ] Bulk "convert to team member" for existing custom authors
- [ ] Author analytics (posts per author, etc.)
- [ ] Co-author ordering (drag-and-drop)

---

## Version 1.2.0 (Future - May be superseded by 2.0)

**Focus:** Developer experience and advanced features

### Planned

- [ ] **REST API for schema data**
  - Endpoint to get schema for any post
  - Endpoint to validate custom schema
  - Useful for headless WordPress setups

- [ ] **Block editor sidebar panel**
  - Move meta box to sidebar panel in Gutenberg
  - Better UX for block editor users
  - Keep classic meta box for Classic Editor

- [ ] **Import/Export settings**
  - Export all settings as JSON
  - Import settings to new site
  - Useful for multi-site deployments

- [ ] **Schema preview in editor**
  - Real-time schema preview while editing
  - Show validation warnings inline

---

## Version 1.3.0 (Future)

**Focus:** Quality and maintainability

### Planned

- [ ] **Unit test coverage**
  - PHPUnit tests for core functionality
  - Test schema generation for each type
  - Test author name formatting
  - Test conflict detection

- [ ] **PHPDoc documentation**
  - Complete PHPDoc blocks for all methods
  - Generate API documentation
  - Type hints for PHP 7.4+

- [ ] **Performance optimization**
  - Profile schema generation
  - Optimize author override for large sites
  - Review output buffering impact
  - Consider lazy loading admin assets

- [ ] **Translation review**
  - Audit all translatable strings
  - Ensure proper text domain usage
  - Generate POT file

---

## Backlog (Unprioritized)

These items are requested or identified but not yet scheduled:

### Features
- [ ] Bulk update schema types for multiple posts
- [ ] Schema validation against Google's requirements
- [ ] Schema templates (save and reuse configurations)
- [ ] Schema inheritance (child pages inherit from parent)
- [ ] Multi-site support with network settings

### Improvements
- [ ] Split large files (setup-wizard.php is 58KB)
- [ ] Extract repeated methods (author name formatting)
- [ ] Add constants for magic strings (author types)
- [ ] Reduce option proliferation further
- [ ] Inline help in admin interfaces

### Integrations
- [ ] WooCommerce Product schema improvements
- [ ] Easy Digital Downloads integration
- [ ] LearnDash Course schema
- [ ] The Events Calendar integration
- [ ] ACF field mapping for schema properties

### Debug/Development
- [ ] Debug mode with detailed logging
- [ ] Schema diff tool (compare before/after)
- [ ] Admin notice for schema validation errors

---

## Completed

### Version 1.1.0 (2026-01-15)
- [x] ISSUE-001: Author name override regression fixed
- [x] ISSUE-002: Taxonomy-based schema type mapping

### Version 1.0.x Series
- [x] Phase 1: Collapsible meta box sections, help text
- [x] Phase 2: Setup completion checklist, dashboard widget
- [x] Phase 3: Meta box visibility controls, sidebar option
- [x] Phase 4: Option consolidation, migration system
- [x] Phase 5: Menu relocation to Settings submenu
- [x] Documentation overhaul (1.0.5)

---

## How to Request Features

1. Check if feature is already in backlog
2. If not, add to backlog with clear description
3. Discuss priority in next planning session
4. Move to versioned milestone when prioritized

---

## Version Planning

| Version | Target | Focus |
|---------|--------|-------|
| ~~1.1.0~~ | ✅ Released | Bug fixes, taxonomy schema mapping |
| **2.0.0** | **Next Major** | **Unified People/Author Architecture** |
| 2.1.0 | Post-2.0 | Refinements to new architecture |
| 1.2.0+ | May skip | Superseded by 2.0 changes |
