# BW AI Schema Pro - Known Issues

**Last Updated:** 2026-01-15

This document tracks known bugs, regressions, and their workarounds.

---

## Active Issues

*No active issues at this time.*

---

## Resolved Issues

### ISSUE-001: Author Name Override Regression (FIXED)

**ID:** ISSUE-001
**Severity:** HIGH
**Status:** Resolved
**Affects:** SPEC.md Section 1.3
**Discovered:** 2026-01 | **Fixed:** 2026-01-15

#### Original Symptom
Theme byline showed WordPress user display name instead of assigned custom/multiple author names.

#### Root Cause
The `init()` method in `class-bw-schema-author-override.php` had a gate check that prevented filters from registering unless `bw_schema_use_custom_authors` option was set to `'yes'`. When posts had custom authors assigned but this global setting was `'no'`, the entire override system was disabled.

**The problematic code (line 20):**
```php
if ( get_option( 'bw_schema_use_custom_authors', 'no' ) !== 'yes' ) {
    return; // Never registered any filters!
}
```

#### Fix Applied
1. **Removed the gate check** - Filters now always register regardless of global setting
2. **Extended JavaScript fallback** - Now runs for single custom authors, not just multiple authors
3. **Added WP author name matching** - JavaScript can now match and replace the WordPress user's display name

#### Files Modified
- `includes/class-bw-schema-author-override.php` (lines 18-27, 1134-1198)

#### Verification
Tested on rise.demoing.info with a post assigned to custom author "Aaron Todrin":
- JSON-LD schema: ✅ Shows "Aaron Todrin"
- Theme byline HTML: ✅ Shows "Aaron Todrin" (PHP filters working)
- JavaScript fallback: ✅ Present as backup

---

### ISSUE-002: Category-Based Schema Type Selection (FIXED)

**ID:** ISSUE-002
**Severity:** MEDIUM
**Status:** Resolved
**Affects:** SPEC.md Section 2.3 (AC-2.3.4)
**Discovered:** 2026-01 | **Fixed:** 2026-01-15

#### Original Requirement
Posts should automatically select schema subtype based on taxonomy terms (e.g., "Case Study" resources → TechArticle, "News" → NewsArticle).

#### Solution Implemented
Added taxonomy-based schema mapping system that allows mapping any taxonomy term to any schema type.

**New priority order for schema type determination:**
1. Post-specific meta override (`_bw_schema_type`)
2. **Taxonomy term mapping** (NEW)
3. Post type default
4. Fallback (`article:Article`)

#### Features Added
- New option `bw_schema_taxonomy_mappings` stores mappings
- `BW_Schema_Core::get_schema_type_for_post()` - centralized schema type determination
- `BW_Schema_Core::get_schema_type_from_taxonomy()` - taxonomy lookup
- UI in Setup Wizard Step 5 (Content Defaults) to configure mappings
- Works with any taxonomy (categories, custom taxonomies, etc.)

#### Files Modified
- `includes/class-bw-schema-core.php` - Added storage/retrieval methods
- `includes/class-bw-schema-renderer.php` - Uses new centralized method
- `admin/views/setup-wizard.php` - Added taxonomy mapping UI
- `includes/class-bw-schema-admin.php` - Added save handler

#### Verification
Tested with Resources post type on rise.demoing.info:
- Case Studies (term `case-studies`) → `article:TechArticle` ✅
- News (term `news`) → `article:NewsArticle` ✅
- Articles (unmapped term) → `article:Article` (post type default) ✅

---

## Issue Template

When adding new issues, use this template:

```markdown
### ISSUE-XXX: Title

**ID:** ISSUE-XXX
**Severity:** HIGH/MEDIUM/LOW
**Status:** Open/In Progress/Resolved
**Affects:** SPEC.md Section X.X
**Discovered:** YYYY-MM

#### Symptom
What the user sees wrong.

#### Expected Behavior
What should happen.

#### Actual Behavior
What actually happens.

#### Technical Details
Where the bug is, relevant code snippets.

#### Workarounds
Any temporary solutions.

#### Investigation Notes
What has been tried, what needs investigation.

#### Files to Investigate
Table of relevant files and line numbers.
```
