# Handoff Notes

Developer-to-developer notes for async collaboration. These are **specific messages** one developer wants to pass to another, beyond the general session summaries.

---

## How to Use

**Adding a note:**
```markdown
### From [Your Name] to [Recipient] - [Date]
**Status:** Unread

[Your message here]
```

**After reviewing:**
Change `**Status:** Unread` to `**Status:** Reviewed by [Name] on [Date]`

**Clearing old notes:**
Move reviewed notes to the "Archive" section at the bottom (or delete if no longer relevant).

---

## Active Notes

### From Rian to Adi - 2026-01-15
**Status:** Unread

Hey Adi! A few things to catch you up on:

---

#### 1. IMPORTANT: New People/Author Architecture (v2.0)

**The key thing to understand:** All Person schema is now housed in the **Team Member post type**. This is the single source of truth for people.

**How it works:**
- Each team member has schema fields in their edit screen (credentials, expertise, LinkedIn, education, etc.)
- The **"Is Author"** checkbox on a team member flags them as available for article authorship
- The **"Is Founder"** checkbox flags them as a company founder (appears in Organization schema)
- These team members automatically sync to the **Authors section** of the BW AI Schema Pro plugin
- When you assign an author to a post, you're selecting from team members flagged as authors

**Data flow:**
```
Team Member CPT → "Is Author" flag → Available in post author dropdown → Article schema
                → "Is Founder" flag → Organization schema founder property
```

**All Rise team member data has been populated!** I went through each team member page and extracted:
- LinkedIn profiles
- Areas of expertise (knowsAbout)
- Education/credentials (alumniOf, hasCredential)
- Professional memberships (memberOf)
- Videos where available

**All 58 articles have been updated** to use Robert DiNozzi as the author (he's the content writer).

---

#### 2. New Documentation & Handoff System

I've set up a comprehensive documentation system. Check out `CLAUDE.md` for the full index.

**How it works for you:**
- When you start a session, Claude will give you a summary of what changed since your last session
- You'll receive any notes I've left for you (like this one)
- If you want to pass notes back to me, just tell Claude to add a handoff note for Rian

---

#### 3. Taxonomy-Based Schema Mapping (v1.1.0)

Posts can auto-select schema type based on taxonomy terms. For example, "Case Studies" category → TechArticle schema.

This is in Setup Wizard → Content Defaults → each post type has a "Map by taxonomy" option.

---

#### 4. Versioning Protocol (New!)

**Increment the version after every change:**
- `0.0.X` bump for each iteration within a task (e.g., 2.0.1 → 2.0.2)
- `0.X.0` bump when moving to a new issue (e.g., 2.0.4 → 2.1.0)

This makes it easy to track exactly what changed between sessions. Update the version in:
1. `CLAUDE.md` (line 3)
2. `bw-ai-schema-pro.php` (plugin header)
3. `docs/CHANGELOG.md` (brief entry)

---

#### 5. Other v2.0 Features

- **ProfilePage + Person schema** on team member pages with reciprocal Organization linking
- **Bylines link to team pages** (not WP author archives)
- **Author archive redirects** - `/author/username/` → team page (301)
- **Setup Wizard Step 2** is now "People" with team member overview
- **Migration tool** for legacy custom authors (already run for Rise)

---

## Archive

*Move reviewed notes here to keep Active Notes clean.*

<!-- Example archived note:
### From Adi to Rian - 2026-01-10
**Status:** Reviewed by Rian on 2026-01-12

[Old message that's been addressed]
-->
