# Changelog

All notable changes to BW AI Schema Pro will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

---

## [Unreleased]

*No unreleased changes*

---

## [2.0.3] - 2026-01-16

### Fixed
- **Author Override memory exhaustion bug** - The Author Override class caused PHP memory exhaustion (256MB) on some sites
  - Added class-level recursion protection (`$is_processing` flag) to prevent infinite loops
  - Removed excessive debug logging (`error_log()` calls with `print_r()` on every filter call)
  - Disabled output buffer approach which was causing memory issues on large pages
  - Reduced filter hooks to essential minimum to improve performance

---

## [2.0.2] - 2026-01-16

### Fixed
- **Custom schema override now works correctly** - When a post has custom JSON-LD in `_bw_schema_custom`, the plugin now outputs ONLY that schema and skips all auto-generated schemas (WebSite, BreadcrumbList, Article, etc.)
  - Custom schema is output directly without going through sanitization, preserving `@graph` and other JSON-LD keywords
  - Useful when sites use external schema generation tools
- **Added `@graph` to security whitelist** - The `@graph` JSON-LD keyword was being stripped by `sanitize_key()` because it wasn't in the schema properties whitelist

---

## [2.0.1] - 2026-01-15

### Fixed
- **Page mappings not reflecting in schema output** - Pages mapped in wizard Step 4 now correctly output their assigned schema types (AboutPage, ContactPage, CollectionPage, etc.)
  - Added `get_schema_type_from_page_mapping()` method to `BW_Schema_Core`
  - Page mapping now checked before taxonomy mapping in schema type priority
- **Leadership in Review tab using old data** - Review tab now shows team members with "Is Founder" flag instead of legacy founders option
- **Organization schema founder property** - Now uses team members with "Is Founder" flag
- **Team page ItemList URL** - Fixed bug where ItemList URL showed first team member URL instead of team page URL
- **Renamed "Is Leader" to "Is Founder"** - More accurate to schema.org `founder` property semantics

### Added
- **Areas Served and Services Offered in wizard** - Now configurable in Step 1 (Organization Profile)
- **Versioning protocol** - Patch version increments on every change for better collaboration tracking

### Data (Rise site)
- Populated schema fields for all 10 team members (LinkedIn, expertise, education, credentials, memberships, videos)
- Set Robert DiNozzi as author on all 58 articles

---

## [2.0.0] - 2026-01-15

### Added - Unified People/Author Architecture
- **New "People" step in Setup Wizard** - Step 2 redesigned to consolidate team, leadership, and author management
  - Team post type configuration (moved from Step 6)
  - Team Members overview table with Is Author, Is Leader, and Linked WP User columns
  - WordPress Users & Default Authors table for per-user author defaults
  - Migration notice for legacy custom authors

- **Team Member as source of truth** - Team members are now the canonical source for public-facing people
  - Person Schema Settings meta box on team member edit screen
  - Core field detection (name, job title, description, image, URL) with overrides
  - Schema enhancement fields (credentials, knowsAbout, sameAs, awards, alumniOf, memberOf)
  - Honorific prefix/suffix support
  - "Is Author" and "Is Leader" flags

- **ProfilePage + Person schema** - Team member pages now output proper ProfilePage schema
  - mainEntity contains full Person schema with @id reference
  - worksFor links to Organization with reciprocal @id
  - Organization schema includes employee array referencing team members

- **v2.0 Author Type System** - New post author selection UI
  - Team Member Author - from team CPT where Is Author = true
  - External Saved Author - reusable guest contributors stored in plugin
  - External One-time Author - ad-hoc per-post authors
  - Legacy WordPress and Custom author types preserved for backwards compatibility

- **Plugin-wide default author** - New fallback when posts have no author assigned
  - Configurable from Authors admin page
  - Falls back after user's personal default

- **Author archive 301 redirects** - `/author/username/` now redirects to team page
  - Only when user has linked team member
  - Configurable via Settings

- **Legacy Custom Author Migration Tool** - Convert old custom authors to v2.0 architecture
  - Auto-matches by name to existing team members
  - Options: Link to team member, convert to external, or delete
  - Automatically updates post references

### Fixed
- **Infinite recursion / memory exhaustion** - Author box no longer causes 24+ second page loads
  - Added static $is_rendering flag to prevent get_the_excerpt recursion
- **Kadence theme byline links** - Byline now shows linked author names instead of plain text
- **Job title not showing in author box** - Fixed detect_job_title receiving post object instead of ID
- **Legacy author type URLs** - Added custom and wordpress cases to filter_author_url
- **Internal vs external links** - Team page links open in same window, external links open in new tab

### Changed
- Step 2 renamed from "Leadership & Team" to "People"
- Team post type setting moved from Step 6 to Step 2
- Author override class now handles all v2.0 author types
- format_author_names() now tracks internal vs external URLs
- Author box simplified design: avatar + name (linked) + job title

### Deprecated
- Old "Custom Authors" system - Use Team Member Authors or External Authors instead
- `bw_schema_use_custom_authors` option - Only controls legacy meta box display

---

## [1.1.0] - 2026-01-15

### Added
- **Taxonomy-based schema type mapping (ISSUE-002)** - Map taxonomy terms to specific schema types
  - Configure which taxonomy to use for schema mapping per post type
  - Map individual terms to different schema types (e.g., "Case Studies" → TechArticle)
  - Falls back to post type default if no mapping matches
  - New UI in Setup Wizard Step 5 (Content Defaults)
  - New methods: `BW_Schema_Core::get_schema_type_for_post()`, `get_schema_type_from_taxonomy()`
  - New option: `bw_schema_taxonomy_mappings`
  - Filterable via `bw_schema_taxonomy_mappings` filter

### Fixed
- **Author name override regression (ISSUE-001)** - Theme byline now correctly shows custom/multiple authors instead of WordPress user
  - Removed gate check that prevented filters from registering when `bw_schema_use_custom_authors` was not 'yes'
  - Extended JavaScript fallback to handle single custom authors (not just multiple)
  - Added WordPress author name matching in JS for more reliable replacement

### Changed
- Schema type determination now uses centralized `BW_Schema_Core::get_schema_type_for_post()` method
- Priority order: post meta > taxonomy mapping > post type default > fallback
- Author override filters now always register and check post meta to decide whether to override
- The `bw_schema_use_custom_authors` setting now only controls what the meta box shows, not whether the override works

---

## [1.0.5] - 2026-01-15

### Added
- Comprehensive documentation system for vibe coding
- CLAUDE.md for AI assistant orientation
- SPEC.md with feature acceptance criteria
- KNOWN-ISSUES.md for bug tracking
- SESSION-LOG.md for development handoffs
- TESTING.md with verification checklists

### Changed
- Reorganized documentation into `docs/` directory

---

## [1.0.4] - 2026-01 (Phase 5)

### Changed
- Relocated plugin menu from root admin to Settings submenu
- Changed `add_menu_page()` to `add_options_page()` in class-bw-schema-admin.php
- Set other pages (settings, authors, setup wizard) as hidden from menu
- Added tab navigation to dashboard.php, settings.php, and author-profiles.php
- Updated all internal URLs from `admin.php?page=` to `options-general.php?page=`

### Files Modified
- bw-ai-schema-pro.php
- class-bw-schema-admin.php
- dashboard.php
- setup-wizard.php
- debug-team-schema.php

---

## [1.0.3] - 2026-01 (Phase 4)

### Added
- Consolidated settings system with `bw_schema_settings` single option
- Helper methods: `get_settings()`, `update_settings()`
- Backward compatibility layer with `get_legacy_option()`
- Automatic migration on plugin init via `maybe_migrate_options()`

### Changed
- Settings now use version-based migration with `SETTINGS_VERSION`

---

## [1.0.2] - 2026-01 (Phase 3)

### Added
- Meta box visibility controls per post type (checkbox grid in settings)
- Sidebar placement option (normal vs side position)
- Default collapsed/expanded state option

### Changed
- Meta box registration now respects all visibility settings

---

## [1.0.1] - 2026-01 (Phase 2)

### Added
- Setup completion checklist in class-bw-schema-core.php
- `get_setup_completion_status()` method
- Completion widget in dashboard.php
- "What's Missing" indicator with priority levels (required/recommended/optional)

---

## [1.0.0] - 2026-01 (Phase 1 + Initial Release)

### Added
- 15 schema types with 30+ subtypes
- Multiple author support (WordPress, Custom, External)
- Author name override system with 40+ filters
- Author box display with shortcode support
- 7-step setup wizard
- Conflict management for Yoast, AIOSEO, Rank Math, SEOPress, WooCommerce
- AI-optimized properties (credibility, expertise, trust, content)
- Collapsible sections in meta box
- Help text in wizard about Organization schema
- Improved auto-detection for Organization pages

### Technical
- Singleton pattern for main plugin class
- SPL autoloader for class loading
- WordPress Options API for settings storage
- Schema caching system
- 80+ developer hooks for extensibility

---

## Version History Summary

| Version | Date | Focus |
|---------|------|-------|
| 1.0.5 | 2026-01-15 | Documentation overhaul |
| 1.0.4 | 2026-01 | Menu relocation (Phase 5) |
| 1.0.3 | 2026-01 | Option consolidation (Phase 4) |
| 1.0.2 | 2026-01 | UI refinement (Phase 3) |
| 1.0.1 | 2026-01 | Dashboard enhancement (Phase 2) |
| 1.0.0 | 2026-01 | Initial release + Phase 1 |

---

## Upgrade Notes

### Upgrading to 1.0.3+
- Settings are automatically migrated to consolidated structure
- Legacy option calls still work via backward compatibility layer
- No action required

### Upgrading to 1.0.4+
- Menu location changed from top-level to Settings > AI Schema Pro
- Bookmarks to old URLs will need updating
