<?php
/**
 * Global Settings view for BW AI Schema Pro
 *
 * NOTE: Most organization settings are now configured in the Setup Wizard.
 * This page contains advanced settings that are not typically needed.
 *
 * @package BW_AI_Schema_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get current settings
$org_data = BW_Schema_Core::get_organization_schema();

// Display any messages
settings_errors( 'bw_schema_settings' );
?>

<div class="wrap bw-schema-admin-wrap">
	<h1><?php _e( 'BW AI Schema Pro', 'bw-ai-schema-pro' ); ?></h1>

	<!-- Tab Navigation -->
	<nav class="nav-tab-wrapper bw-schema-nav-tabs">
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema' ); ?>" class="nav-tab">
			<span class="dashicons dashicons-dashboard"></span>
			<?php _e( 'Dashboard', 'bw-ai-schema-pro' ); ?>
		</a>
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-settings' ); ?>" class="nav-tab nav-tab-active">
			<span class="dashicons dashicons-admin-generic"></span>
			<?php _e( 'Settings', 'bw-ai-schema-pro' ); ?>
		</a>
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-authors' ); ?>" class="nav-tab">
			<span class="dashicons dashicons-admin-users"></span>
			<?php _e( 'Author Profiles', 'bw-ai-schema-pro' ); ?>
		</a>
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup' ); ?>" class="nav-tab">
			<span class="dashicons dashicons-welcome-learn-more"></span>
			<?php _e( 'Setup Wizard', 'bw-ai-schema-pro' ); ?>
		</a>
	</nav>

	<!-- Info Notice -->
	<div class="notice notice-info" style="margin-top: 15px;">
		<p>
			<span class="dashicons dashicons-info"></span>
			<strong><?php _e( 'Tip:', 'bw-ai-schema-pro' ); ?></strong>
			<?php _e( 'Most schema settings are configured in the Setup Wizard. This page contains advanced settings that are optional.', 'bw-ai-schema-pro' ); ?>
			<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup' ); ?>"><?php _e( 'Go to Setup Wizard', 'bw-ai-schema-pro' ); ?> &rarr;</a>
		</p>
	</div>

	<form method="post" action="">
		<?php wp_nonce_field( 'bw_schema_settings', 'bw_schema_settings_nonce' ); ?>

		<div class="bw-schema-form">
			<!-- Advanced Organization Details -->
			<div class="bw-schema-form-section">
				<h2><?php _e( 'Advanced Organization Details', 'bw-ai-schema-pro' ); ?></h2>
				<p class="description"><?php _e( 'Optional fields for enhanced organization schema. Basic info is configured in the Setup Wizard.', 'bw-ai-schema-pro' ); ?></p>

				<div class="bw-schema-form-row">
					<label for="org_alternate_name"><?php _e( 'Alternate/Brand Name', 'bw-ai-schema-pro' ); ?></label>
					<input type="text" id="org_alternate_name" name="org_alternate_name" value="<?php echo esc_attr( $org_data['alternateName'] ?? '' ); ?>" class="regular-text" />
					<p class="description"><?php _e( 'Also known as, DBA, or brand name (e.g., if legal name is "Acme Corp" but commonly known as "Acme")', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="org_legal_name"><?php _e( 'Legal Name', 'bw-ai-schema-pro' ); ?></label>
					<input type="text" id="org_legal_name" name="org_legal_name" value="<?php echo esc_attr( $org_data['legalName'] ?? '' ); ?>" class="regular-text" />
					<p class="description"><?php _e( 'Official registered business name (if different from display name)', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="org_tax_id"><?php _e( 'Tax ID / VAT Number', 'bw-ai-schema-pro' ); ?></label>
					<input type="text" id="org_tax_id" name="org_tax_id" value="<?php echo esc_attr( $org_data['taxID'] ?? '' ); ?>" class="regular-text" />
					<p class="description"><?php _e( 'Business tax identification number', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="org_duns"><?php _e( 'DUNS Number', 'bw-ai-schema-pro' ); ?></label>
					<input type="text" id="org_duns" name="org_duns" value="<?php echo esc_attr( $org_data['duns'] ?? '' ); ?>" class="regular-text" />
					<p class="description"><?php _e( 'Dun & Bradstreet DUNS number (typically for enterprise businesses)', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="org_areas_served"><?php _e( 'Areas Served', 'bw-ai-schema-pro' ); ?></label>
					<textarea id="org_areas_served" name="org_areas_served" rows="2" class="large-text"><?php echo esc_textarea( is_array( $org_data['areaServed'] ?? '' ) ? implode( ', ', $org_data['areaServed'] ) : ( $org_data['areaServed'] ?? '' ) ); ?></textarea>
					<p class="description"><?php _e( 'Geographical areas where you provide services (comma-separated, e.g., "New York, Los Angeles, Chicago")', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="org_services"><?php _e( 'Services/Products Offered', 'bw-ai-schema-pro' ); ?></label>
					<textarea id="org_services" name="org_services" rows="3" class="large-text"><?php echo esc_textarea( is_array( $org_data['makesOffer'] ?? '' ) ? implode( ', ', $org_data['makesOffer'] ) : ( $org_data['makesOffer'] ?? '' ) ); ?></textarea>
					<p class="description"><?php _e( 'Main services or products your organization offers (comma-separated)', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="org_slogan"><?php _e( 'Slogan/Tagline', 'bw-ai-schema-pro' ); ?></label>
					<input type="text" id="org_slogan" name="org_slogan" value="<?php echo esc_attr( $org_data['slogan'] ?? '' ); ?>" class="large-text" />
					<p class="description"><?php _e( 'Your organization\'s motto or tagline', 'bw-ai-schema-pro' ); ?></p>
				</div>
			</div>

			<!-- Author Box Settings -->
			<div class="bw-schema-form-section">
				<h2><?php _e( 'Author Box Settings', 'bw-ai-schema-pro' ); ?></h2>
				<p class="description"><?php _e( 'Configure how and where the author box appears on your site.', 'bw-ai-schema-pro' ); ?></p>

				<?php
				// Get current settings
				$author_box_enabled = get_option( 'bw_schema_author_box_enabled', 'yes' );
				$author_box_post_types = get_option( 'bw_schema_author_box_post_types', array( 'post' ) );
				$author_box_position = get_option( 'bw_schema_author_box_position', 'after_content' );

				// Get all public post types
				$post_types = get_post_types( array( 'public' => true ), 'objects' );
				unset( $post_types['attachment'] ); // Remove attachment post type
				?>

				<div class="bw-schema-form-row">
					<label>
						<input type="checkbox" name="author_box_enabled" value="yes" <?php checked( $author_box_enabled, 'yes' ); ?> />
						<strong><?php _e( 'Enable Author Box', 'bw-ai-schema-pro' ); ?></strong>
					</label>
					<p class="description"><?php _e( 'Display author information box on selected post types.', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label><strong><?php _e( 'Display on Post Types:', 'bw-ai-schema-pro' ); ?></strong></label>
					<div style="margin-top: 10px;">
						<?php foreach ( $post_types as $post_type ) : ?>
							<label style="display: block; margin-bottom: 5px;">
								<input type="checkbox" name="author_box_post_types[]" value="<?php echo esc_attr( $post_type->name ); ?>"
									<?php checked( in_array( $post_type->name, $author_box_post_types ) ); ?> />
								<?php echo esc_html( $post_type->label ); ?> (<?php echo esc_html( $post_type->name ); ?>)
							</label>
						<?php endforeach; ?>
					</div>
					<p class="description"><?php _e( 'Select which post types should display the author box by default.', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="author_box_position"><strong><?php _e( 'Author Box Position:', 'bw-ai-schema-pro' ); ?></strong></label>
					<select id="author_box_position" name="author_box_position" class="regular-text">
						<option value="after_content" <?php selected( $author_box_position, 'after_content' ); ?>><?php _e( 'After Content', 'bw-ai-schema-pro' ); ?></option>
						<option value="before_content" <?php selected( $author_box_position, 'before_content' ); ?>><?php _e( 'Before Content', 'bw-ai-schema-pro' ); ?></option>
						<option value="manual" <?php selected( $author_box_position, 'manual' ); ?>><?php _e( 'Manual (using shortcode)', 'bw-ai-schema-pro' ); ?></option>
					</select>
					<p class="description"><?php _e( 'Choose where the author box appears. Use [bw_author_box] shortcode for manual placement.', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<?php $redirect_author_archives = get_option( 'bw_schema_redirect_author_archives', 'yes' ); ?>
				<div class="bw-schema-form-row">
					<label>
						<input type="checkbox" name="redirect_author_archives" value="yes" <?php checked( $redirect_author_archives, 'yes' ); ?> />
						<strong><?php _e( 'Redirect Author Archives to Team Pages', 'bw-ai-schema-pro' ); ?></strong>
					</label>
					<p class="description"><?php _e( 'When enabled, visiting a WordPress author archive (e.g., /author/username/) will 301 redirect to their linked Team Member page if one exists. This consolidates author presence and improves SEO.', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<p class="description">
						<strong><?php _e( 'Note:', 'bw-ai-schema-pro' ); ?></strong>
						<?php _e( 'Individual posts can override these settings. The author box will show the default author if no specific author is selected.', 'bw-ai-schema-pro' ); ?>
					</p>
				</div>
			</div>

			<!-- Meta Box Display Settings -->
			<div class="bw-schema-form-section">
				<h2><?php _e( 'Meta Box Display Settings', 'bw-ai-schema-pro' ); ?></h2>
				<p class="description"><?php _e( 'Control how the AI Schema Settings meta box appears in the post editor.', 'bw-ai-schema-pro' ); ?></p>

				<?php
				$metabox_position = get_option( 'bw_schema_metabox_position', 'normal' );
				$metabox_default_state = get_option( 'bw_schema_metabox_default_state', 'collapsed' );
				$metabox_post_types = get_option( 'bw_schema_metabox_post_types', array() );

				// If empty, default to all public post types except excluded ones
				if ( empty( $metabox_post_types ) ) {
					$all_post_types = get_post_types( array( 'public' => true ), 'names' );
					$excluded = array( 'attachment' );
					$metabox_post_types = array_diff( $all_post_types, $excluded );
				}
				?>

				<div class="bw-schema-form-row">
					<label for="metabox_position"><?php _e( 'Meta Box Position', 'bw-ai-schema-pro' ); ?></label>
					<select id="metabox_position" name="metabox_position">
						<option value="normal" <?php selected( $metabox_position, 'normal' ); ?>><?php _e( 'Below Editor (Normal)', 'bw-ai-schema-pro' ); ?></option>
						<option value="side" <?php selected( $metabox_position, 'side' ); ?>><?php _e( 'Sidebar (Compact)', 'bw-ai-schema-pro' ); ?></option>
					</select>
					<p class="description"><?php _e( 'Choose where the schema settings box appears. Sidebar is less intrusive but more compact.', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label for="metabox_default_state"><?php _e( 'Default State', 'bw-ai-schema-pro' ); ?></label>
					<select id="metabox_default_state" name="metabox_default_state">
						<option value="collapsed" <?php selected( $metabox_default_state, 'collapsed' ); ?>><?php _e( 'Collapsed (Recommended)', 'bw-ai-schema-pro' ); ?></option>
						<option value="expanded" <?php selected( $metabox_default_state, 'expanded' ); ?>><?php _e( 'Expanded', 'bw-ai-schema-pro' ); ?></option>
					</select>
					<p class="description"><?php _e( 'Set the default state when editing posts. Collapsed keeps the editor clean.', 'bw-ai-schema-pro' ); ?></p>
				</div>

				<div class="bw-schema-form-row">
					<label><?php _e( 'Show Meta Box On', 'bw-ai-schema-pro' ); ?></label>
					<div class="bw-schema-checkbox-grid">
						<?php
						$post_types = get_post_types( array( 'public' => true ), 'objects' );
						$excluded_types = array( 'attachment', 'revision', 'nav_menu_item', 'custom_css', 'customize_changeset', 'oembed_cache', 'user_request', 'wp_block', 'wp_template', 'wp_template_part', 'wp_navigation' );

						foreach ( $post_types as $post_type ) {
							if ( in_array( $post_type->name, $excluded_types ) ) {
								continue;
							}
							$checked = in_array( $post_type->name, (array) $metabox_post_types );
							?>
							<label class="checkbox-item">
								<input type="checkbox" name="metabox_post_types[]" value="<?php echo esc_attr( $post_type->name ); ?>" <?php checked( $checked ); ?> />
								<?php echo esc_html( $post_type->labels->name ); ?>
								<span class="post-type-slug">(<?php echo esc_html( $post_type->name ); ?>)</span>
							</label>
							<?php
						}
						?>
					</div>
					<p class="description"><?php _e( 'Select which post types should display the schema settings meta box. Unchecked types will still use default schema settings.', 'bw-ai-schema-pro' ); ?></p>
				</div>
			</div>
		</div>

		<p class="submit">
			<input type="submit" name="bw_schema_save_settings" class="button-primary" value="<?php _e( 'Save Settings', 'bw-ai-schema-pro' ); ?>" />
		</p>
	</form>
</div>
