# BW AI Schema Pro - Development Guide

**Version:** 2.0.4 | **Status:** Stable | **Last Updated:** 2026-01-16

WordPress plugin for JSON-LD schema markup optimized for AI systems and search engines.

---

## VERSIONING PROTOCOL (Required)

**Claude: Increment the version after EVERY change you make.**

| Change Type | Version Bump | Example |
|-------------|--------------|---------|
| Each update/iteration within a task | `0.0.X` | 2.0.1 → 2.0.2 → 2.0.3 |
| Completing a task, moving to new issue | `0.X.0` | 2.0.3 → 2.1.0 |
| Major release | `X.0.0` | 2.1.0 → 3.0.0 |

**After making any code change:**
1. Increment the patch version in this file (`CLAUDE.md` line 3)
2. Increment the version in `bw-ai-schema-pro.php` (plugin header)
3. Add a brief entry to `docs/CHANGELOG.md`

**Example:** If Adi is cleaning up the wizard and it takes 3 iterations:
- First change: 2.0.1 → 2.0.2
- Second change: 2.0.2 → 2.0.3
- Third change: 2.0.3 → 2.0.4
- Moving to next issue: 2.0.4 → 2.1.0

This makes it easy to track exactly what changed between sessions.

---

## SESSION START PROTOCOL (Required)

**Claude: Follow these steps at the start of EVERY session before doing any work:**

1. **Identify the current user** by checking who is logged in
2. **Read `docs/SESSION-LOG.md`** to find this user's last session
3. **Read `docs/HANDOFF-NOTES.md`** for any unread notes addressed to this user
4. **Summarize changes since their last session** including:
   - Sessions that happened after their last one
   - Files modified
   - Issues fixed or discovered
   - Current state of the plugin
5. **Deliver any handoff notes** from other developers (if any unread notes exist)
6. **Ask the user to confirm** they understand before proceeding with any work

Example opening:
> "Welcome back, [user]! Since your last session on [date], here's what changed: [summary].
>
> **You have a note from [other developer]:** [brief summary of note]
>
> Ready to continue, or do you have questions?"

**If this is a user's first session**, summarize the current state instead:
> "Hi [user]! This looks like your first session on this plugin. Here's the current state: [summary]. What would you like to work on?"

**After delivering handoff notes:** Mark them as reviewed in `docs/HANDOFF-NOTES.md` once the user acknowledges them.

---

## Current Status

**All known issues resolved!** The plugin is stable for production use.

### Recently Fixed (v1.1.0 - 2026-01-15)
- **ISSUE-001:** Author name override regression - Theme byline now correctly shows custom/multiple authors
- **ISSUE-002:** Taxonomy-based schema type mapping - Posts can now auto-select schema subtype based on taxonomy terms (e.g., Case Studies → TechArticle)

### Planned: v2.0 Unified People Architecture
See `docs/DESIGN-v2-authors.md` for the upcoming refactor that will make Team Members the source of truth for public-facing people.

---

## Quick Architecture Reference

### Entry Point
```
bw-ai-schema-pro.php → BW_AI_Schema_Pro::get_instance() (singleton)
```

### Key Classes

| Class | File | Purpose |
|-------|------|---------|
| `BW_AI_Schema_Pro` | `bw-ai-schema-pro.php` | Main orchestrator, hooks, meta box |
| `BW_Schema_Core` | `includes/class-bw-schema-core.php` | Settings, schema types, conflicts |
| `BW_Schema_Renderer` | `includes/class-bw-schema-renderer.php` | Schema output orchestration |
| `BW_Schema_Author_Override` | `includes/class-bw-schema-author-override.php` | Author display filtering (40+ hooks) |
| `BW_Schema_Author_Box` | `includes/class-bw-schema-author-box.php` | Frontend author box |
| `BW_Schema_Admin` | `includes/class-bw-schema-admin.php` | Admin pages, settings UI |
| `BW_Schema_Base` | `includes/schemas/class-bw-schema-base.php` | Abstract base for schema types |

### Key Files by Feature

| Feature | Primary File | Secondary |
|---------|--------------|-----------|
| Author display override | `class-bw-schema-author-override.php` | `class-bw-schema-author-box.php` |
| Schema output | `class-bw-schema-renderer.php` | `includes/schemas/*.php` |
| Admin UI | `class-bw-schema-admin.php` | `admin/views/*.php` |
| Settings management | `class-bw-schema-core.php` | - |
| Team pages | `class-bw-schema-team-detector.php` | `class-bw-schema-team-member.php` |

---

## Schema Types Supported

15 main types with 30+ subtypes:
- Article (BlogPosting, NewsArticle, TechArticle, ScholarlyArticle)
- Person (Author, Expert)
- Organization (Corporation, Educational, Government, NGO)
- LocalBusiness (9 subtypes)
- Product, Event, HowTo, FAQ, Review, Recipe, Video, Course, JobPosting, WebPage

---

## Author System

### Three Author Types
1. **WordPress** - Native WP user accounts
2. **Custom** - Defined in plugin settings (`bw_schema_custom_authors` option)
3. **External** - Ad-hoc per-post authors

### Multiple Authors
- Stored in `_bw_schema_multiple_authors` post meta
- Formats: "A and B" (2), "A, B and C" (3), "A, B, C and X others" (6+)

---

## Data Storage

### Options (wp_options)
| Key | Purpose |
|-----|---------|
| `bw_schema_settings` | Consolidated settings (v2.0.0+) |
| `bw_schema_organization` | Organization data |
| `bw_schema_custom_authors` | Custom author profiles |
| `bw_schema_post_type_defaults` | Default schemas per post type |

### Post Meta
| Key | Purpose |
|-----|---------|
| `_bw_schema_type` | Selected schema type |
| `_bw_schema_multiple_authors` | Author assignments |
| `_bw_schema_disable` | Disable schema for post |
| `_bw_schema_custom` | Custom JSON-LD override |

---

## Before Making Changes

1. Read `docs/SPEC.md` for feature requirements and acceptance criteria
2. Check `docs/KNOWN-ISSUES.md` for related bugs
3. Review `docs/SESSION-LOG.md` for recent context
4. Understand which acceptance criteria your change affects

## After Making Changes

1. Verify against `docs/TESTING.md` checklist
2. Update `docs/CHANGELOG.md` with changes
3. Update `docs/SESSION-LOG.md` with session summary
4. If acceptance criteria status changed, update `docs/SPEC.md`

---

## Developer Hooks (Selected)

```php
// Modify any schema type before output
add_filter('bw_schema_article', function($schema, $post, $type) {
    return $schema;
}, 10, 3);

// Modify all schemas before output
add_filter('bw_schema_rendered_schemas', function($schemas) {
    return $schemas;
});

// Add custom schema type
BW_Schema_Hooks::add_schema_type('podcast', 'Podcast', 'description', 'icon', []);
```

See `docs/ARCHITECTURE.md#hooks` for full list (80+ filters/actions).

---

## Documentation Index

| Document | Purpose |
|----------|---------|
| `docs/SPEC.md` | Feature requirements with acceptance criteria |
| `docs/KNOWN-ISSUES.md` | Current bugs and workarounds |
| `docs/CHANGELOG.md` | Version history |
| `docs/ROADMAP.md` | Future work, prioritized |
| `docs/ARCHITECTURE.md` | Technical reference |
| `docs/SESSION-LOG.md` | Session history and summaries |
| `docs/HANDOFF-NOTES.md` | Developer-to-developer notes |
| `docs/TESTING.md` | Verification checklists |
| `docs/DESIGN-v2-authors.md` | v2.0 architecture design |
| `docs/guides/team-schema.md` | User guide for team pages |

---

## Quick Commands

```bash
# Check site schema output
curl -s https://bwgeo.demoing.info/ | grep -A 100 "BW AI Schema Pro"

# Validate schema
# Visit: https://search.google.com/test/rich-results

# View container logs
srv-gw logs --project bwgeo
```
