<?php
/**
 * Debug author display for BW AI Schema Pro
 * Access this file directly to debug author issues
 */

// Load WordPress
require_once('../../../../wp-load.php');

// Check if user is admin
if (!current_user_can('manage_options')) {
    wp_die('Access denied');
}

// Get post ID from query string
$post_id = isset($_GET['post_id']) ? intval($_GET['post_id']) : 0;

if (!$post_id) {
    wp_die('Please provide a post_id in the URL (e.g., ?post_id=1640)');
}

// Get post
$post = get_post($post_id);
if (!$post) {
    wp_die('Post not found');
}

// Get multiple authors meta
$multiple_authors = get_post_meta($post_id, '_bw_schema_multiple_authors', true);
$custom_authors_list = get_option('bw_schema_custom_authors', array());

?>
<!DOCTYPE html>
<html>
<head>
    <title>Author Debug - Post <?php echo $post_id; ?></title>
    <style>
        body { font-family: monospace; padding: 20px; }
        pre { background: #f0f0f0; padding: 10px; overflow: auto; }
        .author-box { border: 1px solid #ccc; padding: 10px; margin: 10px 0; }
        .error { color: red; }
        .success { color: green; }
    </style>
</head>
<body>
    <h1>Author Debug for Post: <?php echo esc_html($post->post_title); ?> (ID: <?php echo $post_id; ?>)</h1>
    
    <h2>Multiple Authors Data:</h2>
    <pre><?php print_r($multiple_authors); ?></pre>
    
    <h2>Available Custom Authors:</h2>
    <pre><?php print_r($custom_authors_list); ?></pre>
    
    <h2>Author Processing:</h2>
    <?php
    if (!empty($multiple_authors) && is_array($multiple_authors)) {
        echo "<p>Total authors configured: " . count($multiple_authors) . "</p>";
        
        $found_authors = array();
        $missing_authors = array();
        
        foreach ($multiple_authors as $index => $author_data) {
            echo "<div class='author-box'>";
            echo "<h3>Author " . ($index + 1) . ":</h3>";
            echo "<pre>" . print_r($author_data, true) . "</pre>";
            
            $name = null;
            $found = false;
            
            switch ($author_data['type']) {
                case 'wordpress':
                    if (!empty($author_data['wordpress_user_id'])) {
                        $user = get_userdata($author_data['wordpress_user_id']);
                        if ($user) {
                            $name = $user->display_name;
                            $found = true;
                            echo "<p class='success'>✓ Found WordPress user: " . esc_html($name) . "</p>";
                        } else {
                            echo "<p class='error'>✗ WordPress user ID " . $author_data['wordpress_user_id'] . " not found!</p>";
                        }
                    }
                    break;
                    
                case 'custom':
                    if (!empty($author_data['custom_author_id'])) {
                        echo "<p>Looking for custom author ID: " . esc_html($author_data['custom_author_id']) . "</p>";
                        $found_custom = false;
                        foreach ($custom_authors_list as $custom_author) {
                            if ($custom_author['id'] === $author_data['custom_author_id']) {
                                $name = $custom_author['name'];
                                $found = true;
                                $found_custom = true;
                                echo "<p class='success'>✓ Found custom author: " . esc_html($name) . "</p>";
                                break;
                            }
                        }
                        if (!$found_custom) {
                            echo "<p class='error'>✗ Custom author ID '" . esc_html($author_data['custom_author_id']) . "' not found in database!</p>";
                            echo "<p>Available custom author IDs: ";
                            $ids = array_map(function($a) { return $a['id']; }, $custom_authors_list);
                            echo esc_html(implode(', ', $ids));
                            echo "</p>";
                        }
                    }
                    break;
                    
                case 'external':
                    if (!empty($author_data['external']['name'])) {
                        $name = $author_data['external']['name'];
                        $found = true;
                        echo "<p class='success'>✓ Found external author: " . esc_html($name) . "</p>";
                    } else {
                        echo "<p class='error'>✗ External author has no name!</p>";
                    }
                    break;
                    
                default:
                    echo "<p class='error'>✗ Unknown author type: " . esc_html($author_data['type']) . "</p>";
            }
            
            if ($found && $name) {
                $found_authors[] = $name;
            } else {
                $missing_authors[] = $author_data;
            }
            
            echo "</div>";
        }
        
        echo "<h2>Summary:</h2>";
        echo "<p>Authors found: " . count($found_authors) . "</p>";
        echo "<p>Authors missing: " . count($missing_authors) . "</p>";
        echo "<p>Found names: " . esc_html(implode(', ', $found_authors)) . "</p>";
        
        // Test formatting
        echo "<h2>Format Test:</h2>";
        echo "<p>With " . count($found_authors) . " authors, the display would be:</p>";
        
        // Simulate the format_author_names function
        $count = count($found_authors);
        if ($count === 1) {
            echo "<p><strong>" . $found_authors[0] . "</strong></p>";
        } elseif ($count === 2) {
            echo "<p><strong>" . $found_authors[0] . ' and ' . $found_authors[1] . "</strong></p>";
        } elseif ($count === 3) {
            echo "<p><strong>" . $found_authors[0] . ', ' . $found_authors[1] . ' and ' . $found_authors[2] . "</strong></p>";
        } elseif ($count === 4) {
            echo "<p><strong>" . $found_authors[0] . ', ' . $found_authors[1] . ', ' . $found_authors[2] . ' and ' . $found_authors[3] . "</strong></p>";
        } elseif ($count === 5) {
            echo "<p><strong>" . $found_authors[0] . ', ' . $found_authors[1] . ', ' . $found_authors[2] . ', ' . $found_authors[3] . ' and ' . $found_authors[4] . "</strong></p>";
        } else {
            $others_count = $count - 3;
            echo "<p><strong>" . $found_authors[0] . ', ' . $found_authors[1] . ', ' . $found_authors[2] . ' and ' . $others_count . ' ' . ($others_count === 1 ? 'other' : 'others') . "</strong></p>";
        }
        
    } else {
        echo "<p>No multiple authors configured for this post.</p>";
    }
    ?>
</body>
</html>