<?php
/**
 * Dashboard view for BW AI Schema Pro
 *
 * @package BW_AI_Schema_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Get configuration data
$org_data = BW_Schema_Core::get_organization_schema();
$business_type = get_option( 'bw_schema_business_type', '' );
$post_type_defaults = BW_Schema_Core::get_post_type_defaults();
$page_mappings = get_option( 'bw_schema_page_mappings', array() );
$founders = get_option( 'bw_schema_founders', array() );
$custom_authors = get_option( 'bw_schema_custom_authors', array() );
$use_custom_authors = get_option( 'bw_schema_use_custom_authors', 'wordpress' );
$schema_enabled = get_option( 'bw_schema_enable_schema', 'yes' );
$breadcrumbs_enabled = get_option( 'bw_schema_enable_breadcrumbs', 'yes' );
$price_range_enabled = get_option( 'bw_schema_enable_price_range', 'no' );
$price_range = get_option( 'bw_schema_price_range', '' );
$schema_types = BW_Schema_Core::get_schema_types();

// Get setup completion status
$completion_status = BW_Schema_Core::get_setup_completion_status();

// Display any messages
settings_errors( 'bw_schema_dashboard' );

// Get actual page titles for mappings
$mapped_pages = array();
foreach ( $page_mappings as $type => $page_id ) {
	if ( $page_id ) {
		$page = get_post( $page_id );
		if ( $page ) {
			$mapped_pages[$type] = $page->post_title;
		}
	}
}

// Business type labels
$business_type_labels = array(
	'professional' => __( 'Professional Services', 'bw-ai-schema-pro' ),
	'medical' => __( 'Medical/Healthcare', 'bw-ai-schema-pro' ),
	'hospitality' => __( 'Hospitality', 'bw-ai-schema-pro' ),
	'education' => __( 'Educational Institution', 'bw-ai-schema-pro' ),
	'ecommerce' => __( 'E-commerce', 'bw-ai-schema-pro' ),
	'technology' => __( 'Technology/Software', 'bw-ai-schema-pro' ),
	'realestate' => __( 'Real Estate', 'bw-ai-schema-pro' ),
	'financial' => __( 'Financial Services', 'bw-ai-schema-pro' ),
	'media' => __( 'Media/Publishing', 'bw-ai-schema-pro' ),
	'nonprofit' => __( 'Non-Profit', 'bw-ai-schema-pro' ),
	'government' => __( 'Government', 'bw-ai-schema-pro' ),
	'personal' => __( 'Personal/Individual', 'bw-ai-schema-pro' ),
);

// Page type labels
$page_type_labels = array(
	'home' => __( 'Homepage', 'bw-ai-schema-pro' ),
	'about' => __( 'About Page', 'bw-ai-schema-pro' ),
	'services' => __( 'Services/Products', 'bw-ai-schema-pro' ),
	'contact' => __( 'Contact Page', 'bw-ai-schema-pro' ),
	'blog' => __( 'Blog Index', 'bw-ai-schema-pro' ),
	'team' => __( 'Team/Staff Page', 'bw-ai-schema-pro' ),
	'terms' => __( 'Terms of Service', 'bw-ai-schema-pro' ),
	'privacy' => __( 'Privacy Policy', 'bw-ai-schema-pro' ),
);

// Find default author (v2.0 - plugin-wide default from Authors page)
$default_author = null;
$plugin_default = get_option( 'bw_schema_plugin_default_author', array() );
if ( ! empty( $plugin_default['type'] ) && ! empty( $plugin_default['id'] ) ) {
	if ( $plugin_default['type'] === 'team_member' ) {
		$team_member = get_post( intval( $plugin_default['id'] ) );
		if ( $team_member ) {
			$job_title_data = class_exists( 'BW_Schema_Team_Member' )
				? BW_Schema_Team_Member::detect_job_title( $team_member )
				: '';
			$job_title = is_array( $job_title_data ) ? ( $job_title_data['value'] ?? '' ) : $job_title_data;
			$default_author = $team_member->post_title . ( $job_title ? ' (' . $job_title . ')' : '' );
		}
	} elseif ( $plugin_default['type'] === 'external' ) {
		$external_authors = get_option( 'bw_schema_external_authors', array() );
		if ( isset( $external_authors[ $plugin_default['id'] ] ) ) {
			$ext = $external_authors[ $plugin_default['id'] ];
			$default_author = $ext['name'] . ( ! empty( $ext['jobTitle'] ) ? ' (' . $ext['jobTitle'] . ')' : '' );
		}
	}
}

// Legacy fallback: check old isDefault system if no v2.0 default is set
if ( ! $default_author ) {
	if ( $use_custom_authors === 'custom' ) {
		foreach ( $custom_authors as $author ) {
			if ( ! empty( $author['isDefault'] ) ) {
				$default_author = $author['name'] . ' (' . $author['jobTitle'] . ')';
				break;
			}
		}
	} else {
		foreach ( $founders as $founder ) {
			if ( ! empty( $founder['isDefault'] ) ) {
				$default_author = $founder['name'] . ' (' . $founder['jobTitle'] . ')';
				break;
			}
		}
	}
}
?>

<div class="wrap bw-schema-admin-wrap">
	<?php if ( isset( $_GET['setup_complete'] ) && $_GET['setup_complete'] == '1' ) : ?>
	<div class="notice notice-success is-dismissible">
		<p>
			<strong><?php _e( 'Setup Complete!', 'bw-ai-schema-pro' ); ?></strong>
			<?php _e( 'Your schema markup has been configured and is now active on your site.', 'bw-ai-schema-pro' ); ?>
		</p>
	</div>
	<?php endif; ?>
	
	<h1><?php _e( 'BW AI Schema Pro', 'bw-ai-schema-pro' ); ?></h1>

	<!-- Tab Navigation -->
	<nav class="nav-tab-wrapper bw-schema-nav-tabs">
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema' ); ?>" class="nav-tab nav-tab-active">
			<span class="dashicons dashicons-dashboard"></span>
			<?php _e( 'Dashboard', 'bw-ai-schema-pro' ); ?>
		</a>
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-settings' ); ?>" class="nav-tab">
			<span class="dashicons dashicons-admin-generic"></span>
			<?php _e( 'Settings', 'bw-ai-schema-pro' ); ?>
		</a>
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-authors' ); ?>" class="nav-tab">
			<span class="dashicons dashicons-admin-users"></span>
			<?php _e( 'Author Profiles', 'bw-ai-schema-pro' ); ?>
		</a>
		<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup' ); ?>" class="nav-tab">
			<span class="dashicons dashicons-welcome-learn-more"></span>
			<?php _e( 'Setup Wizard', 'bw-ai-schema-pro' ); ?>
		</a>
	</nav>

	<!-- Quick Status -->
	<div class="bw-schema-status-bar">
		<div class="status-item <?php echo $schema_enabled === 'yes' ? 'active' : 'inactive'; ?>">
			<span class="status-label"><?php _e( 'Schema:', 'bw-ai-schema-pro' ); ?></span>
			<span class="status-value"><?php echo $schema_enabled === 'yes' ? __( 'Active', 'bw-ai-schema-pro' ) : __( 'Disabled', 'bw-ai-schema-pro' ); ?></span>
		</div>
		<div class="status-item">
			<span class="status-label"><?php _e( 'Organization:', 'bw-ai-schema-pro' ); ?></span>
			<span class="status-value"><?php echo esc_html( $org_data['name'] ); ?></span>
		</div>
		<div class="status-item">
			<span class="status-label"><?php _e( 'Business Type:', 'bw-ai-schema-pro' ); ?></span>
			<span class="status-value"><?php echo esc_html( $business_type_labels[$business_type] ?? $business_type ); ?></span>
		</div>
		<?php if ( $default_author ) : ?>
		<div class="status-item">
			<span class="status-label"><?php _e( 'Default Author:', 'bw-ai-schema-pro' ); ?></span>
			<span class="status-value"><?php echo esc_html( $default_author ); ?></span>
		</div>
		<?php endif; ?>
	</div>

	<!-- Setup Completion Widget -->
	<div class="bw-schema-completion-widget">
		<div class="completion-header">
			<h2>
				<?php _e( 'Setup Completion', 'bw-ai-schema-pro' ); ?>
				<span class="completion-percentage status-<?php echo esc_attr( $completion_status['status'] ); ?>">
					<?php echo $completion_status['percentage']; ?>%
				</span>
			</h2>
			<?php if ( $completion_status['percentage'] < 100 ) : ?>
			<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup' ); ?>" class="button button-primary button-small">
				<?php _e( 'Complete Setup', 'bw-ai-schema-pro' ); ?>
			</a>
			<?php endif; ?>
		</div>

		<div class="completion-progress">
			<div class="progress-bar-container">
				<div class="progress-bar-fill status-<?php echo esc_attr( $completion_status['status'] ); ?>" style="width: <?php echo $completion_status['percentage']; ?>%;"></div>
			</div>
			<div class="progress-stats">
				<span class="stat">
					<strong><?php echo $completion_status['required_complete']; ?>/<?php echo $completion_status['required_total']; ?></strong>
					<?php _e( 'Required', 'bw-ai-schema-pro' ); ?>
				</span>
				<span class="stat">
					<strong><?php echo $completion_status['recommended_complete']; ?>/<?php echo $completion_status['recommended_total']; ?></strong>
					<?php _e( 'Recommended', 'bw-ai-schema-pro' ); ?>
				</span>
			</div>
		</div>

		<div class="completion-checklist">
			<?php
			$incomplete_items = array_filter( $completion_status['checks'], function( $check ) {
				return ! $check['complete'];
			});
			$complete_items = array_filter( $completion_status['checks'], function( $check ) {
				return $check['complete'];
			});
			?>

			<?php if ( ! empty( $incomplete_items ) ) : ?>
			<div class="checklist-section incomplete">
				<h4><?php _e( 'Missing Items', 'bw-ai-schema-pro' ); ?></h4>
				<ul>
					<?php foreach ( $incomplete_items as $key => $check ) : ?>
					<li class="checklist-item priority-<?php echo esc_attr( $check['priority'] ); ?>">
						<span class="check-icon dashicons dashicons-marker"></span>
						<div class="check-content">
							<span class="check-label"><?php echo esc_html( $check['label'] ); ?></span>
							<span class="check-priority"><?php echo esc_html( ucfirst( $check['priority'] ) ); ?></span>
						</div>
						<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup&step=' . $check['step'] ); ?>" class="check-action">
							<?php _e( 'Configure', 'bw-ai-schema-pro' ); ?>
						</a>
					</li>
					<?php endforeach; ?>
				</ul>
			</div>
			<?php endif; ?>

			<?php if ( ! empty( $complete_items ) ) : ?>
			<div class="checklist-section complete <?php echo empty( $incomplete_items ) ? 'expanded' : 'collapsed'; ?>">
				<h4 class="toggle-section">
					<?php _e( 'Completed Items', 'bw-ai-schema-pro' ); ?>
					<span class="dashicons dashicons-arrow-down-alt2"></span>
				</h4>
				<ul style="<?php echo empty( $incomplete_items ) ? '' : 'display: none;'; ?>">
					<?php foreach ( $complete_items as $key => $check ) : ?>
					<li class="checklist-item completed">
						<span class="check-icon dashicons dashicons-yes-alt"></span>
						<div class="check-content">
							<span class="check-label"><?php echo esc_html( $check['label'] ); ?></span>
						</div>
					</li>
					<?php endforeach; ?>
				</ul>
			</div>
			<?php endif; ?>
		</div>
	</div>

	<div class="bw-schema-dashboard-main">
		<!-- Configuration Summary -->
		<form method="post" action="">
			<?php wp_nonce_field( 'bw_schema_dashboard', 'bw_schema_dashboard_nonce' ); ?>
			
			<div class="bw-schema-section">
				<h2><?php _e( 'Configuration Summary', 'bw-ai-schema-pro' ); ?></h2>
				
				<table class="bw-schema-summary-table widefat">
					<tbody>
						<tr>
							<td class="section-header" colspan="2">
								<strong><?php _e( 'Schema Settings', 'bw-ai-schema-pro' ); ?></strong>
							</td>
						</tr>
						<tr>
							<th><?php _e( 'Schema Output', 'bw-ai-schema-pro' ); ?></th>
							<td>
								<span class="status-badge <?php echo $schema_enabled === 'yes' ? 'active' : 'inactive'; ?>">
									<?php echo $schema_enabled === 'yes' ? __( 'Enabled', 'bw-ai-schema-pro' ) : __( 'Disabled', 'bw-ai-schema-pro' ); ?>
								</span>
							</td>
						</tr>
						<tr>
							<th><?php _e( 'Breadcrumb Schema', 'bw-ai-schema-pro' ); ?></th>
							<td>
								<span class="status-badge <?php echo $breadcrumbs_enabled === 'yes' ? 'active' : 'inactive'; ?>">
									<?php echo $breadcrumbs_enabled === 'yes' ? __( 'Enabled', 'bw-ai-schema-pro' ) : __( 'Disabled', 'bw-ai-schema-pro' ); ?>
								</span>
							</td>
						</tr>
						<tr>
							<th><?php _e( 'Price Range', 'bw-ai-schema-pro' ); ?></th>
							<td>
								<?php if ( $price_range_enabled === 'yes' && ! empty( $price_range ) ) : ?>
									<span class="status-badge active"><?php echo esc_html( $price_range ); ?></span>
								<?php else : ?>
									<span class="status-badge inactive"><?php _e( 'Not Set', 'bw-ai-schema-pro' ); ?></span>
								<?php endif; ?>
							</td>
						</tr>
						
						<tr>
							<td class="section-header" colspan="2">
								<strong><?php _e( 'Page Mappings', 'bw-ai-schema-pro' ); ?></strong>
							</td>
						</tr>
						<?php if ( ! empty( $mapped_pages ) ) : ?>
							<?php foreach ( $mapped_pages as $type => $title ) : ?>
							<tr>
								<th><?php echo esc_html( $page_type_labels[$type] ?? $type ); ?></th>
								<td><?php echo esc_html( $title ); ?></td>
							</tr>
							<?php endforeach; ?>
						<?php else : ?>
							<tr>
								<td colspan="2" class="no-items"><?php _e( 'No pages mapped yet', 'bw-ai-schema-pro' ); ?></td>
							</tr>
						<?php endif; ?>
						
						<tr>
							<td class="section-header" colspan="2">
								<strong><?php _e( 'Content Type Defaults', 'bw-ai-schema-pro' ); ?></strong>
								<span class="description"><?php _e( 'Set default schema types for each post type', 'bw-ai-schema-pro' ); ?></span>
							</td>
						</tr>
						<?php 
						$post_types = get_post_types( array( 'public' => true ), 'objects' );
						foreach ( $post_types as $post_type ) : 
							$current_default = isset( $post_type_defaults[$post_type->name] ) ? $post_type_defaults[$post_type->name] : '';
						?>
						<tr>
							<th><?php echo esc_html( $post_type->label ); ?></th>
							<td>
								<select name="post_type_defaults[<?php echo $post_type->name; ?>]" class="schema-type-select">
									<option value=""><?php _e( '-- No Default Schema --', 'bw-ai-schema-pro' ); ?></option>
									<?php foreach ( $schema_types as $type_key => $type_data ) : ?>
										<optgroup label="<?php echo esc_attr( $type_data['label'] ); ?>">
											<?php foreach ( $type_data['subtypes'] as $subtype_key => $subtype_label ) : ?>
												<?php $value = $type_key . ':' . $subtype_key; ?>
												<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $current_default, $value ); ?>>
													<?php echo esc_html( $subtype_label ); ?>
												</option>
											<?php endforeach; ?>
										</optgroup>
									<?php endforeach; ?>
								</select>
							</td>
						</tr>
						<?php endforeach; ?>
					</tbody>
				</table>
				
				<p class="submit">
					<input type="submit" name="bw_schema_save_dashboard" class="button-primary" value="<?php _e( 'Save Changes', 'bw-ai-schema-pro' ); ?>" />
				</p>
			</div>
		</form>
		
		<!-- Quick Links -->
		<div class="bw-schema-section">
			<h2><?php _e( 'Quick Actions', 'bw-ai-schema-pro' ); ?></h2>
			
			<div class="bw-schema-button-group">
				<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-setup' ); ?>" class="button button-primary">
					<?php _e( 'Run Setup Wizard', 'bw-ai-schema-pro' ); ?>
				</a>
				<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-settings' ); ?>" class="button">
					<?php _e( 'Global Settings', 'bw-ai-schema-pro' ); ?>
				</a>
				<a href="<?php echo admin_url( 'options-general.php?page=bw-ai-schema-authors' ); ?>" class="button">
					<?php _e( 'Manage Authors', 'bw-ai-schema-pro' ); ?>
				</a>
				<a href="<?php echo admin_url( 'edit.php' ); ?>" class="button">
					<?php _e( 'Edit Posts', 'bw-ai-schema-pro' ); ?>
				</a>
				<a href="<?php echo admin_url( 'edit.php?post_type=page' ); ?>" class="button">
					<?php _e( 'Edit Pages', 'bw-ai-schema-pro' ); ?>
				</a>
			</div>
			
			<h3><?php _e( 'Validation Tools', 'bw-ai-schema-pro' ); ?></h3>
			<div class="bw-schema-button-group">
				<a href="https://validator.schema.org/" target="_blank" class="button">
					<?php _e( 'Schema.org Validator', 'bw-ai-schema-pro' ); ?>
				</a>
				<a href="https://search.google.com/test/rich-results" target="_blank" class="button">
					<?php _e( 'Google Rich Results Test', 'bw-ai-schema-pro' ); ?>
				</a>
			</div>
		</div>
	</div>
</div>

<style>
/* Basic Dashboard Styles */
.bw-schema-admin-wrap h1 {
	margin-bottom: 20px;
}

/* Status Bar */
.bw-schema-status-bar {
	background: #f0f0f1;
	border: 1px solid #c3c4c7;
	border-radius: 4px;
	padding: 12px 15px;
	margin-bottom: 30px;
	display: flex;
	gap: 30px;
	flex-wrap: wrap;
}

.bw-schema-status-bar .status-item {
	display: flex;
	align-items: center;
	gap: 8px;
}

.bw-schema-status-bar .status-label {
	font-weight: 600;
	color: #50575e;
}

.bw-schema-status-bar .status-value {
	color: #2c3338;
}

.bw-schema-status-bar .status-item.active .status-value {
	color: #00a32a;
	font-weight: 600;
}

.bw-schema-status-bar .status-item.inactive .status-value {
	color: #d63638;
	font-weight: 600;
}

/* Main Content */
.bw-schema-dashboard-main {
	max-width: 800px;
}

/* Sections */
.bw-schema-section {
	margin-bottom: 40px;
}

.bw-schema-section h2 {
	margin-bottom: 15px;
}

.bw-schema-section h3 {
	margin-top: 20px;
	margin-bottom: 10px;
}

/* Summary Table */
.bw-schema-summary-table {
	border: 1px solid #c3c4c7;
	background: #fff;
}

.bw-schema-summary-table th,
.bw-schema-summary-table td {
	padding: 12px;
}

.bw-schema-summary-table th {
	width: 30%;
	font-weight: 400;
	color: #50575e;
}

.bw-schema-summary-table .section-header {
	background: #f6f7f7;
	font-weight: 600;
	color: #2c3338;
	border-bottom: 1px solid #c3c4c7;
}

.bw-schema-summary-table .no-items {
	text-align: center;
	color: #787c82;
	font-style: italic;
}

/* Status Badges */
.status-badge {
	display: inline-block;
	padding: 3px 8px;
	border-radius: 3px;
	font-size: 12px;
	font-weight: 500;
}

.status-badge.active {
	background: #d7f7e4;
	color: #00a32a;
}

.status-badge.inactive {
	background: #fcf0f1;
	color: #d63638;
}

/* Button Groups */
.bw-schema-button-group {
	display: flex;
	gap: 10px;
	flex-wrap: wrap;
	margin-bottom: 15px;
}

/* Select Elements */
.schema-type-select {
	width: 300px;
	max-width: 100%;
}

.bw-schema-section .description {
	color: #787c82;
	font-size: 13px;
	font-style: italic;
	margin-left: 10px;
}

/* Responsive */
@media (max-width: 600px) {
	.bw-schema-status-bar {
		flex-direction: column;
		gap: 10px;
	}
	
	.bw-schema-button-group {
		flex-direction: column;
	}
	
	.bw-schema-button-group .button {
		width: 100%;
		text-align: center;
	}
	
	.schema-type-select {
		width: 100%;
	}
}
</style>